% makefile for building mxlpsolve for lpsolve VERSION 5.1
%
% Usage: MakefileWin({what {, debug {, wait}}})
%  what: '' or not provided: compile build all source code
%        else any combination of lpsolve.c, matlab.c hash.c
%  debug: 0 or not provided: no debug info
%         1: argument checking and print extra debug info.
%  wait: 1 or not provided: ask to press a key before starting compiling
%        0: immediately start compiling

function MakefileWin(what, debug, wait)

lpsolvepath='..\..\..';

if nargin == 0 | isempty(what)
        what = 'lpsolve.c matlab.c hash.c';
end

if nargin < 2
        debug = 0;
end

if debug == 0
        debug = '';
else
        debug = '-argcheck -DDEBUG'
end

if nargin < 3
        wait = 1;
end

disp('Automatic compilation of Matlab MEX interface for lp_solve 5.1 under Windows.');
disp(' ');
disp(['We assume that lp_solve 5.1 is installed in: ' lpsolvepath]);
disp('If that is not correct path for lp_solve 5.1, modify this file accordingly.');
disp(' ');
disp('***************************************************************');
disp('*  Old version of MEX lp_solve files will be overwritten !!!  *');
disp('***************************************************************');
disp(' ');
if wait == 0
else
	disp('Press any key to continue');
	disp(' ');
	pause;
end
disp('Compiling in progress. Please wait...');

% Windows environment
%--------------------

% compile lp that uses lp_solve 5.1
eval(['mex ' debug ' -DMATLAB -I' lpsolvepath ' -c ' what]);
eval(['mex ' debug ' lpsolve.obj matlab.obj hash.obj lp_explicit.lib -output mxlpsolve']);

disp('Compiling finished.');
disp('You can now run ex and lpdemo on matlab command line to test.');