#include "matlab.h"

int nlhs;
int nrhs;
pMatrix plhs;
pMatrix prhs;

void setargs(int nlhs0, int nrhs0, pMatrix plhs0, pMatrix prhs0)
{
        nlhs = nlhs0;
        nrhs = nrhs0;
        plhs = plhs0;
        prhs = prhs0;
}


/* Function to get a real scalar with error checking */

REAL GetRealScalar(pMatrix ppm)
{
        Matrix pm = *ppm;

	if ((GetM(pm) == 1) && (GetN(pm) == 1)
	  && (IsNumeric(pm)) && (!IsComplex(pm)) ) {
		return(mxGetScalar(pm));
	} else {
		ErrMsgTxt("Expecting a scalar argument.");
	}
        return(0.0);
}

#define GetVector(pm, vec, start, len, exactcount, ret) \
{ \
	int	j, k, k1, m, n, count = 0; \
	int	*ir, *jc; \
	double	*pr, *pr0; \
        void    *vec0; \
 \
	m = GetM(pm); \
	n = GetN(pm); \
 \
	if ( !((m == 1) || (n == 1)) || \
             ((m == 1) && (((exactcount) && (len != n)) || ((!exactcount) && (n > len)))) || \
             ((n == 1) && (((exactcount) && (len != m)) || ((!exactcount) && (m > len)))) || \
	     !IsNumeric(pm) || IsComplex(pm)) { \
		ErrMsgTxt("invalid vector."); \
	} \
 \
	pr = GetPr(pm); \
 \
	if (!IsSparse(pm)) { \
                if (n == 1) \
                        len = m; \
                else \
                        len = n; \
                vec += start; \
		for (k = 0; k < len; k++, pr++, vec++) { \
			*vec = *pr; \
		} \
                count = len; \
	} else if (IsSparse(pm)) { \
		jc = mxGetJc(pm); \
		ir = mxGetIr(pm); \
                pr0 = pr; \
                vec0 = vec; \
                for (j = 0; j < n; j++) { \
                        k = jc[j]; \
                        k1 = jc[j + 1]; \
                        pr = pr0 + k; \
                        vec = vec0; \
                        vec += start + j * m; \
                        for (; k < k1; k++, pr++) { \
				vec[ir[k]] = *pr; \
                                count++; \
			} \
		} \
	} else { \
		ErrMsgTxt("Can't figure out this matrix."); \
	} \
 \
        ret = count; \
}

/* Functions to get len elements from a MATLAB vector. Matrix
   can be either full or sparse. Elements are stored in indices
   start..start+n-1  Errors out if the MATLAB vector is not length len */

int GetIntVector(pMatrix ppm, int *vec, int start, int len, int exactcount)
{
        int ret;

        GetVector(*ppm, vec, start, len, exactcount, ret)

        return(ret);
}

int GetRealVector(pMatrix ppm, REAL *vec, int start, int len, int exactcount)
{
        int ret;

        GetVector(*ppm, vec, start, len, exactcount, ret)

        return(ret);
}


/* Function to get max len elements from a MATLAB sparse vector. Matrix
   can be either full or sparse. Elements are stored in indices
   start..start+n-1  Errors out if the MATLAB vector is longer than length len */

int GetRealSparseVector(pMatrix ppm, REAL *vec, int *index, int start, int len, int col)
{
	int	j, k, k1, m, n, start1, count = 0;
	int	*ir, *jc;
	double	*pr, *pr0;
        Matrix pm = *ppm;

	m = GetM(pm);
	n = GetN(pm);

	if (  ((col == 0) && (((m != 1) && (n != 1)) || ((m == 1) && (n > len)) || ((n == 1) && (m > len)))) ||
              ((col != 0) && ((m > len) || (col > n))) ||
	      !IsNumeric(pm) ||
              IsComplex(pm)  ) {
		ErrMsgTxt("invalid vector.");
	}

	pr = GetPr(pm);

	if (!IsSparse(pm)) {
                if ((((n == 1) || (col != 0)) && (m != len)) || ((col == 0) && (m == 1) && (n != len)))
                        ErrMsgTxt("invalid vector.");

                if (col)
                	pr += (col - 1) * m;
                for (k = 0; k < len; k++, pr++) {
                        if (*pr) {
				*(vec++) = *pr;
                        	*(index++) = start + k;
                        	count++;
                        }
		}
	} else if (IsSparse(pm)) {
                int j1, j2;

		jc = mxGetJc(pm);
		ir = mxGetIr(pm);
                pr0 = pr;
                if (col == 0) {
                        j1 = 0;
                        j2 = n;
                }
                else {
                        j1 = col - 1;
                        j2 = col;
                }
		for (j = j1; j < j2; j++) {
                        k = jc[j];
                        k1 = jc[j + 1];
                        pr = pr0 + k;
                        start1 = start;
                        if (col == 0)
                        	start1 += j * m;
                        for (; k < k1; k++, pr++, vec++, index++) {
                                *vec = *pr;
                                *index = start1 + ir[k];
                                count++;
			}
		}
	} else {
		ErrMsgTxt("Can't figure out this matrix.");
	}

        return(count);
}


void GetString(pMatrix ppm, char *buf, int size)
{
        Matrix pm = *ppm;

	if (!mxIsChar(pm))
                ErrMsgTxt("Expecting a character element.");
	mxGetString(pm, buf, size);
}

strArray GetCellCharItems(pMatrix ppm, int len)
{
        int m, n, i;
        Matrix pm = *ppm;
        pMatrix pa0, **pa;

        if (!mxIsCell(pm))
                ErrMsgTxt("Expecting a cell argument.");

        m = GetM(pm);
        n = GetN(pm);
        if (!(((m == 1) && (n == len)) || ((n == 1) && (m == len))))
                ErrMsgTxt("invalid vector.");
        pa = pa0 = (pMatrix) matCalloc(len, sizeof(*pa));
        for (i = 0; i < len; i++) {
        	*pa = mxGetCell(pm, i);
        	if (!mxIsChar(*pa))
                        break;
                pa++;
        }
        if (i < len) {
                matFree(pa0);
        	ErrMsgTxt("Expecting a character cell element.");
        }
        return(pa0);
}


void FreeCellCharItems(strArray pa, int len)
{
	matFree(pa);
}

double *CreateDoubleMatrix(int m, int n, Matrix plhs[])
{
	plhs[0] = mxCreateDoubleMatrix(m, n, 0);
	return(GetPr(plhs[0]));
}

MatrixEl CreateString(char **str, int n, Matrix plhs[])
{
        Matrix pa;

 	pa = mxCreateString(str[0]);
        if (plhs != NULL)
        	plhs[0] = pa;
        return(pa);
}
