#include "mex.h"

#include "lp_lib.h"

#define LPSOLVEAPIEXPLICIT

#include "lp_explicit.h"

#define ErrMsgTxt mexErrMsgTxt
#define drivername "mxlpsolve"
#define caller "MATLAB"
#define IsNumeric mxIsNumeric
#define IsComplex mxIsComplex
#define IsSparse mxIsSparse
#define GetM mxGetM
#define GetN mxGetN
#define GetpMatrix(pm) (*(pm))
#define GetPr mxGetPr
#define matCalloc mxCalloc
#define matFree mxFree
#define GetCellString GetString
#define Printf mexPrintf

#define MatrixEl mxArray *
#define pMatrix MatrixEl *
#define Matrix MatrixEl
#define strArray pMatrix

#define HasCellMatrix

#define callerPrototype void mexFunction(int nlhs, mxArray *plhs0[], int nrhs, const mxArray *prhs0[])

#define publicargs() \
        mxArray **plhs, **prhs; \
\
        plhs = (mxArray **) plhs0; \
        prhs = (mxArray **) prhs0; \
        setargs(nlhs, nrhs, plhs, prhs)

#define registerExitFcn() if (mexAtExit(ExitFcn)) ErrMsgTxt("Failed to register exit function.\n")

extern int nlhs;
extern int nrhs;
extern pMatrix plhs;
extern pMatrix prhs;

extern void setargs(int	nlhs0, int nrhs0, pMatrix plhs0, pMatrix prhs0);
extern REAL GetRealScalar(pMatrix ppm);
extern int GetIntVector(pMatrix ppm, int *vec, int start, int len, int exactcount);
extern int GetRealVector(pMatrix ppm, REAL *vec, int start, int	len, int exactcount);
extern int GetRealSparseVector(pMatrix ppm, REAL *vec, int *index, int start, int len, int col);
extern void GetString(pMatrix ppm, char *buf, int size);
extern strArray GetCellCharItems(pMatrix ppm, int len);
extern void FreeCellCharItems(strArray pa, int len);
extern double *CreateDoubleMatrix(int m, int n, pMatrix plhs);
extern MatrixEl CreateString(char **str, int n, pMatrix plhs);
