function bytesFree=Bytes(command);
% bytesFree=Bytes([command]);
%
% Bytes is a MEX file that tells you about free memory.  The simplest way to
% use it, is with no input argument:
% 
% freeMemory = Bytes;
%
% The Mac and Win versions each accept different, OS-specific commands, and will
% exit with an error if ask for a command of the wrong type. The Mac version will exit with 
% an error if passed a command for the Win version, and vice versa.  To make your 
% scripts portable between Mac and Windows, test for the operating system type before
% calling Bytes, by using Matlab's pre-defined variable "computer".  For example,
% because Bytes defaults to the 'Free' option on Mac and the 'SystemRAMFree' 
% on Win, the example given above is equivalent to:
%
% switch computer
% case 'MAC2'
% 	freeMemory=Bytes('Free');
% case 'PCWIN'
% 	freeMemory=Bytes('SystemRAMFree');
% default
% end
%
% See separate Mac: and Win: sections below.  
% 
% Mac: 
%
% 	free=Bytes('Free');               % Apple's FreeMem().     Innocuous.  **Default**.
% 	tempFree=Bytes('TempFree');       % Apple's TempFreeMem(). Innocuous.
% 	maxBlock=Bytes('MaxBlock');       % Apple's MaxBlock().    Innocuous.
% 	stackSpace=Bytes('StackSpace');   % Apple's StackSpace().  Innocuous.
% 	maxBlock=Bytes('MaxMem');         % Apple's MaxMem().      CAUTION: moves memory!
% 	tempMaxBlock=Bytes('TempMaxMem'); % Apple's TempMaxMem().  CAUTION: moves memory!
% 
% The FreeMem function returns the total amount of free memory in the current heap. 
% Because these bytes might be dispersed throughout memory, it is ordinarily not 
% possible to allocate a single contiguous block of that size.
% 
% "The TempFreeMem function returns the total amount of free temporary memory that 
% you could allocate by calling TempNewHandle. The returned value is the total 
% number of free bytes. Because these bytes might be dispersed throughout memory, 
% it is ordinarily not possible to allocate a single relocatable block of that size."
% 
% "The MaxBlock function returns the maximum contiguous space, in bytes, that you 
% could obtain after compacting the current heap zone. MaxBlock does not actually 
% do the compaction."
% 
% "The StackSpace function returns the current amount of stack space (in bytes) 
% ... at the instant of return from the trap. Ordinarily, you determine the maximum 
% amount of stack space you need before you ship your application. In general, 
% therefore, this routine is useful only during debugging to determine how big to 
% make the stack. However, if your application calls a recursive function that 
% conceivably could call itself many times, that function should keep track of the 
% stack space and take appropriate action if it becomes too low."
% 
% "The MaxMem function compacts the current heap zone and purges all relocatable, 
% unlocked, and purgeable blocks from the zone. It returns the size, in bytes, of 
% the largest contiguous free block in the zone after the compacting and purging."
% 
% "The TempMaxMem function compacts the current heap zone and returns the size of 
% the largest contiguous block available for temporary allocation." 
% 
% (source: Apple's Mac Programmer's Toolbox Assistant QuickView database.)
%
% Win:
%
% 	bytes=Bytes('SystemRAMFree');        % Msoft's MEMORYSTATUS.dwAvailPhys **default**
% 	bytes=Bytes('SystemRAM');            % Msoft's MEMORYSTATUS.dwTotalPhys
% 	fraction=Bytes('SystemRAMLoad');     % Msoft's MEMORYSTATUS.dwMemoryLoad 
% 	bytes=Bytes('SystemPage');           % Msoft's MEMORYSTATUS.dwTotalPageFile
% 	bytes=Bytes('SystemPageFree');       % Msoft's MEMORYSTATUS.SystemPageFree
% 	bytes=Bytes('SystemTotal');          % Msoft's MEMORYSTATUS.dwTotalVirtual
% 	bytes=Bytes('SystemTotalFree');      % Msoft's MEMORYSTATUS.dwAvailVirtual
%
% Windows implements a virtual memory system, where processes execute in a virtual
% memory space comprised of both RAM and page files on the hard drive.  Each process
% has its own virtual memory space allocated from the total pool of system RAM and 
% memory paging space on your hard drive.  You can use Bytes to detect the amount 
% of unused system RAM and then insure that your script does not use more than the
% amount available.  If your script uses close to or more than the amount of free 
% memory, then Windows will page memory storage from RAM to the hard drive, 
% slowing your script to a crawl.    
%
% Use Bytes('SystemRAMFree') to check the amount of available free memory.  Free 
% memory levels of 4MB or less will probably force disk paging, and you might need to 
% maintain more free memory than that to prevent paging.  You can check the total 
% system RAM by using Bytes('SystemRAM').  Using more  memory in your Matlab script 
% than there is physical memory will certainly force a page, so be sure not to 
% do that if you care about performance.   
%
% System RAM is shared among all processes, so the amount of free RAM available to 
% Matlab at any time will depend not only on the amount of memory that Matlab has used, but 
% also the amount used by other processes, and on how much of that memory used by other 
% processes is paged out to disk.  You can leave more free RAM for Matlab and the 
% Psychtoolbox by closing other applications.
%  
% Bytes on Windows is provided to allow good portability of Matlab scripts between computers, 
% which have different amounts of system memory and varying amounts of free memory.  For 
% good portability between computers, your scripts should check to see if available RAM 
% exceeds the  requirements of the script by a reasonable margin.  If a script detects 
% insufficient RAM, then it could suggest closing other applications to free RAM or adding
% more RAM to the computer.  
% 
% See also: BytesTest 

% HISTORY:
% 	1/20/97	dgp	wrote it
%   4/17/02 awi wrote Windows section.  Lengthened preamble to sections.  Left Mac section untouched.  
