function [isAvail,eventType]=EventAvail(eventType1,eventType2,eventType3,eventType4,eventType5)
% [isAvail,eventType]=EventAvail(['mouseUp'],['mouseDown'],['keyDown'],['autoKey'],['update'],...)
% 
% EventAvail.mex returns 1 if an event of the requested type(s) is
% available in the event queue, and 0 otherwise. You must supply at least
% one eventType. If you supply more than one eventType, then you may want
% to use the optional second output argument to know which eventType
% EventAvail found (the highest in the event queue). EventAvail.mex simply
% calls the Mac OS function EventAvail.
% 
% CharAvail.m returns EventAvail('keyDown'). To test for mouse clicks, use
% EventAvail('mouseDown','mouseUp');
%
% WARNING: When BACKGROUNDING is enabled, Matlab removes all
% characters from the event queue before executing each Matlab
% statement, so CharAvail and EventAvail('keyDown') always report 0.
% So turn off BACKGROUNDING:
% 	Screen('Preference','Backgrounding',0); % Until Matlab 5.2.1, this call required a disk access, which is slow.
% 
% See also: FlushEvents, CharAvail, GetChar, KbCheck, KbWait, KbDemo, KbName, Screen Preference Backgrounding.

% 8/16/97 dgp Wrote it.
% 3/12/98 dgp Explain backgrounding.
% 3/19/99 dgp Update explanation of backgrounding. 
% 3/28/99 dgp Show how to turn off backgrounding.
% 2/19/04 awi Added numbers to eventType arguments, MATLAB 6.5 parses the
%               function declaration in an .m documentation file and does not 
%               like multiple input arguments with the same name.   
