function oldOn=FileShare(on,askBeforeChange)
% oldOn=FileShare([on],[askBeforeChange])
% 
% Control file sharing.  Gets current status before call.  If the "on"
% argument is passed (-1,-2,or -3), sets filesharing accordingly. If
% boolean "askBeforeChange" is 1, then we explicitly ask the user for
% permission in all questionable cases.  Thus
%   oldOn=FileShare(-3,1);
%   ...
%   FileShare(oldOn)
% is a fairly conservative way to control filesharing during execution
% of your experiments.  When writing programs that other people may
% run, we suggest using this form.  Let us know if it fails to handle
% any cases reasonably.
% 
% oldOn:
%   -3 means off or not supported.
%   -2 means starting up.
%   -1 means on.
% n>=0 means scheduled to shut down in n minutes.
% 
% on:
%   -3 means turn off.
%   -2 means turn on.
%   -1 means turn on.
%   any other passed value is ignored (default).
% 
% askBeforeChange:
% 	0 means no (default)
% 	1 means yes
% 	any other value is flagged as an error
% 
% NOTE: We have only tested this routine with Personal Fileshare
% (which is included in Mac OS 7 and later), not with Appleshare (the
% server software you can buy separately).  It should work with
% Appleshare, but there are some message pointers that are irrelevant
% with Filesharing that may matter with Appleshare. We think we set
% them up properly, but we couldn't test it. Would anyone want to run
% experiments on their Appleshare server?
% 
% FS.mex does the work, but has an ugly user interface.

% 3/4/97  dhb  Wrote it at suggestion of dgp.
% 3/20/97 dhb  Modifications for fuller status reporting.
%         dhb  Added ask before change.
% 3/24/97 dhb  Initialize ok properly.
% 1/13/98 dgp  Changed "was" to "is", because I found the past tense confusing.
% 9/26/99 dgp  Cosmetic.
%2/19/04  awi  Exit on Windows


if isPCWIN
    error('Win: FileShare not yet supported.');
end
if nargout>1 | nargin>2
	fprintf('Usage: oldOn=FileShare([on],[askBeforeChange])');
end
oldOn=FS('Check');
ok=1;
if nargin<2
	askBeforeChange=0;
end
if nargin>0
	if on==-1 | on==-2
		if askBeforeChange
			if oldOn==-3
				ok=input('Filesharing is off.  OK to turn it on? (1=yes,0=no) ');
			elseif oldOn > 0
				fprintf('Filesharing is scheduled to shut down in %g minutes.\n',oldOn);
				ok=input('OK to turn it on? (1=yes,0=no) ');
			end
			if ~ok
				return;
			end
		end
		FS('On');
	elseif on==-3
		if askBeforeChange
			if oldOn==-2 | oldOn==-1
				ok=input('Filesharing is on or starting up.  OK to turn it off? (1=yes,0=no) ');
			elseif oldOn > 0
				fprintf('Filesharing is scheduled to shut down in %g minutes.\n',oldOn);
				ok=input('OK to turn it off immediately? (1=yes,0=no) ');
			end
			if ~ok
				return;
			end
		end
		FS('Off');
	end
end
