function hz=FrameRate(w)
% hz = FrameRate(windowPtrOrScreenNumber)
% 
% FrameRate immediately returns the monitor's frame rate, in Hz. If
% windowPtrOrScreenNumber is an array, then "hz" will be an array of
% the same size, with frame rates for each window/screen.
% 
% FrameRate simply returns Screen(w,'FrameRate'). This instantly
% returns the frame rate last measured by Screen for that screen (eg
% when you first opened a window on that screen or forced a
% measurement).  If you manually change the frame rate (eg using the
% Monitors control panel), the old value cached by Screen FrameRate
% will be stale, so you should flush everything, eg CLEAR Screen, or
% force Screen to remeasure it by calling Screen(w,'FrameRate',NaN).
% 
% Also see ScreenTest, BlankingInterruptRate, and "Screen FrameRate?".
% 
% Denis Pelli

% 14 July 1998 dgp wrote it.
% 10/3/99 dgp Removed all the fancy testing code, to create the new DriverTest.m.
% 2/24/02 dgp Deal gracefully with missing frame rate.

if nargin~=1 | nargout>1 | isempty(w) | ~isa(w,'double') | isnan(w)
	error('Usage: hz=FrameRate(windowPtrOrScreenNumber)');
end
% w is array
hz=zeros(size(w));
for i=1:length(w(:))
	% This Screen function is instantaneous, returning the value from an old measurement.
	f=Screen(w(i),'FrameRate');
	if ~isempty(f)
		hz(i)=f;
	else
		hz(i)=nan;
	end
end
