function [char,when] = GetChar
% [char,when] = GetChar
% 
% Wait (if necessary) for a typed character and return it.
% 
% Mac: "when" is a struct. It returns the time of the keypress, the "adb"
% address of the input device, and the state of all the modifier keys (shift,
% control, command, option, alphaLock) and the mouse button.
% If you have multiple keyboards connected, "address" may allow you to
% distinguish which is responsible for the key press. "when.ticks"
% is the value of GetTicks when the key was pressed. "when.secs" is an
% estimate, based on when.ticks, of what GetSecs would have been. Since
% it's derived from a tick count, it's coarsely quantized in steps of
% 1/60.15 s. If you plan to use the value of when.secs then you should
% make sure that the Psychtoolbox has a fresh estimate of tick0secs by
% calling Screen('Preference','Tick0Secs',nan).
% 
% Mac: Command-Period always causes an immediate exit.
% 
% GetChar and CharAvail are character-oriented (and slow), whereas KbCheck
% and KbWait are keypress-oriented (and fast). If only a meta key (like
% <option> or <shift>) was hit, KbCheck will return true, because a key
% was pressed, but CharAvail will return false, because no character was
% generated. See KbCheck.
% 
% CharAvail and GetChar use the Event Manager to retrieve the character
% generated, not the raw key press(es) per se. If the user presses "a",
% GetChar returns 'a', but if the user presses option-e followed by "a",
% this selects an accented a, "", which is treated by GetChar as a single
% character, even though it took the user three keypresses (counting the
% option key) to produce it.
% 
% CharAvail and GetChar call the Event Manager, which allows the system to
% get control. Sometimes CharAvail will take tens of milliseconds to
% return, so don't use CharAvail in real-time loops. And there can be some
% delay between when the key is pressed and when CharAvail or GetChar
% detects it. If precise timing of the keypress is important, use KbCheck
% or KbWait.
% 
% Mac warning: When BACKGROUNDING is enabled, Matlab removes all
% characters from the event queue before executing each Matlab statement,
% so CharAvail and EventAvail('keyDown') always report 0. So turn off
% BACKGROUNDING:
% 	Screen('Preference','Backgrounding',0); % quick in Matlab 5.2.1, otherwise slow.
% 
% See also: GetCharTest, KbCheck, KbWait, CharAvail, KbDemo, EventAvail, 
% Screen Preference Backgrounding.

% 5/7/96  dgp	Wrote this help file.
% 1/22/97 dhb	Added comment and pointer to TIMER routines.
% 3/6/97  dhb	References to KbWait, KbCheck.
% 7/23/97 dgp	It's a character not a keypress.
% 8/2/97  dgp	Explain difference between key and character. See KbCheck.
% 2/7/98  dgp	Streamlined. Eliminated call to GetKey, since it's now GetChar.mex.
% 3/24/98 dgp	Explain backgrounding and meta keys. Don't mention obsolete GetKey and KbHit.
% 3/15/99 xmz	Put in some comment for Windows version.
% 3/19/99 dgp	Update explanation of backgrounding. 
% 3/28/99 dgp	Show how to turn off backgrounding. 
% 8/19/00 dgp	Cosmetic. 
% 4/23/02 dgp   Fixed GetChar.mex to always quit on command-period.
% 4/27/02 dgp	Added optional second return argument.
% 6/1/02  dgp	Mention Tick0Secs.
% 9/21/02 dgp   Added address field to "when", using C code donated by Tom Busey.
