function GetMouse
% [x,y,buttons] = GetMouse([windowPtrOrScreenNumber])
% 
% Returns the current (x,y) position of the cursor and the up/down state
% of the mouse buttons. "buttons" is a 1xN matrix where N is the number of
% mouse buttons. Each element of the matrix represents one mouse button.
% The element is true (1) if the corresponding mouse button is pressed and
% false (0) otherwise. (Win: There may be up to 3 buttons. Mac: Currently
% supports only 1 button. Does anyone use more buttons?)
%
% % Test if any mouse button is pressed. 
% if any(buttons)
%   fprintf('Someone''s pressing a button.\n');
% end
% 
% % Test if the first mouse button is pressed.
% if buttons(1)
%   fprintf('Someone''s pressing the first button!\n');
% end
%
% % Test if the second mouse button is pressed.
% if length(buttons)>=2 & buttons(2)
%   fprintf('Someone''s pressing the second button!\n');
% end
%
% length(buttons) tells you how many buttons there are on your mouse.
%
% The cursor position (x,y) is "local", i.e. relative to the origin of
% the window or screen, if supplied. Otherwise it's "global", i.e. relative
% to the origin of the main screen (the one with the menu bar).
% 
% NOTE: If you use GetMouse to wait for clicks, don't forget to wait
% for the user to release the mouse button, ending the current click, before
% you begin waiting for the next mouse press.
%
% fprintf('Please click the mouse now.\n');
% [x,y,buttons] = GetMouse;
% while any(buttons) % if already down, wait for release
% 	[x,y,buttons] = GetMouse;
% end
% while ~any(buttons) % wait for press
% 	[x,y,buttons] = GetMouse;
% end
% while any(buttons) % wait for release
% 	[x,y,buttons] = GetMouse;
% end
% fprintf('You clicked! Thanks.\n');
% 
% NOTE: GetMouse no longer supports this obsolete usage:
% xy = GetMouse([windowPtrOrScreenNumber])
% where xy is a 1x2 vector containing the x, y coordinates.
%  
% See also: GetClicks, SetMouse

% 4/27/96  dhb  Wrote this help file.
% 5/12/96  dgp  Removed confusing comment about columns.
%               Added query about coordinates.
% 5/16/96  dhb  Modified MEX file to conform to above usage, answered
%               query about coordinates.
% 5/29/96  dhb  Flushing mouse button events added by dgp.
% 8/23/96  dhb  Added support for windowInfo argument.
% 2/24/97  dgp	Updated.
% 2/24/97  dgp	Updated comments about flushing mouse button events.
% 3/10/97  dgp	windowPtrOrScreenNumber
% 3/23/97  dgp	deleted obsolete comment about flushing mouse button events.
% 5/9/00   dgp  Added note about waiting for release before waiting for next click.
% 8/5/01   awi  Added examples and modified to document new size of returned button matrix
%				on windows.  
% 8/6/01   awi  Added See also line for GetClicks and note about prior Windows version.
% 4/13/02  dgp  Cosmetic.
% 5/16/02  awi  Changed Win GetMouse to return variable number of button values and updated 
%               help accordingly.  
% 5/20/02  dgp  Cosmetic.
% 5/22/02  dgp  Note that obsolete usage is no longer supported.
% 6/10/01  awi  Added SetMouse to see also.
