function PatchTrap(name,seconds);
% PatchTrap(name,[seconds])
%
% PatchTrap is a MEX function that temporarily disables any of several
% Apple Macintosh traps: GetNextEvent, WaitNextEvent, EventAvail, PrimeTime.
% The patch is a no-op, returning immediately instead of calling the
% original routine. All the traps are automatically re-enabled once the
% specified number of seconds elapse. You can reenable the traps sooner 
% by calling PatchTrap with zero "seconds". If not specified, the default
% number of "seconds" is 5.
%
% PatchTrap is a way to temporarily suspend processing of external events
% as a way of speeding things up. Matlab's Backgrounding uses WaitNextEvent
% to give up time to other processes; this can be temporarily
% disabled by calling PatchTrap('WaitNextEvent').
%
% The main purpose in creating this function was to work around a bug in
% Matlab 5.0, which was fixed in Matlab 5.1. Matlab 5.0 makes a spurious
% call to GetMenuBar before each call to any MEX, which wastes 0.4 ms
% every time, and leaks 64 bytes of memory. Using PatchTrap to substitute
% a dummy routine for GetMenuBar eliminates the bug.
% 	PatchTrap('GetMenuBar',2)
%	... do time-critical stuff ...
% 	PatchTrap('GetMenuBar',0)
% NOTE: Student Matlab is still at version 5.0, and has the bug.
% WARNING: Matlab crashes if you click the debug icon in the editor window
% toolbar while 'GetMenuBar' is patched.

% HISTORY:
% 	4/9/97	dgp	Wrote it
% 	4/10/97	dgp	Renamed from IgnoreEvents to PatchTrap.
% 	6/4/97	dgp	Added warning about patching GetMenuBar.
% 	2/28/98	dgp	Updated comments about Matlab 5.0 and 5.1.
