function v=PsychtoolboxVersion
% PsychtoolboxVersion returns a number indicating the version. 

% 2/9/01 awi added fullfile command for platform-independent pathname   
% 6/29/02 dgp Use new PsychtoolboxRoot function to cope with user-changed folder names.

global Psychtoolbox

if ~isfield(Psychtoolbox,'version')
	% Get version and date of Psychtoolbox from Psychtoolbox:Contents.m
	Psychtoolbox.version=0;
	file=fullfile(PsychtoolboxRoot,'Contents.m');
	f=fopen(file,'r');
	fgetl(f);
	s=fgetl(f);
	fclose(f);
	[Psychtoolbox.version,count,errmsg,n]=sscanf(s,'%% Version %f',1);
	ss=s(n:end);
	Psychtoolbox.date=ss(min(find(ss-' ')):end);
end
v=Psychtoolbox.version;
