function Screen
% 	Screen is a MEX file to use on- and off-screen windows for display in
% 	experiments. Screen has many functions; type "Screen" for a list:
% 		Screen
% 	For explanation of any particular screen function, just add a question
% 	mark "?". E.g. for 'OpenWindow', try either of these equivalent forms:
% 		Screen('OpenWindow?')
% 		Screen OpenWindow?
% 	All the Screen Preference settings are documented together:
% 		Screen Preference?
% 	
% 	Each on-screen window normally fills a monitor's whole screen. (The Mac
% 	version allows smaller windows; the Win version doesn't.) Off-screen
% 	windows are invisible, but useful as an intermediate place to create and
% 	store images for later display. Copying from window to window is very
% 	fast, e.g. 36 MB/s on a PowerMac 7500/100 and 171 MB/s on a PowerBook
% 	G4/500. It's easy to precompute a series of off-screen windows and then
% 	show them as a movie, in real time, one per video frame.
% 	
%	Screen ARGUMENTS
% 	
% 	"windowPtr" argument: Screen 'OpenWindow' and 'OpenOffscreenWindow' both
% 	return a windowPtr, a number that designates the window you just
% 	created. You can create many windows. And you can obtain a windowPtr to
% 	any of Matlab's windows. To use a window, you pass its windowPtr to the
% 	Screen function you want to apply to that window.
% 	
% 	"rect" argument: "rect" is a 1x4 matrix containing the upper left and
% 	lower right coordinates of an imaginary box containing all the pixels.
% 	Thus a rect [0 0 1 1] contains just one pixel. All screen and window
% 	coordinates follow Apple Macintosh conventions. (In Apple's the pixels
% 	occupy the space between the coordinates.) Coordinates can be local to
% 	the window (i.e. 0,0 origin is at upper left of window), or local to the
% 	screen (origin at upper left of screen), or "global", which follows
% 	Apple's convention of treating the entire desktop (all your screens) as
% 	one big screen, with origin at the upper left of the main screen, which
% 	has the menu bar. You can rearrange the screens in the desktop by using
% 	Apple's Control Panel: Monitors or Monitors and Sounds. Historically
% 	we've had two different orderings of the elements of rect, so, for
% 	general compatibility, all of the Psychophysics Toolbox refers to the
% 	elements symbolically, through RectLeft, RectTop, etc. Since 2/97, we
% 	use Apple's standard ordering: RectLeft=1, RectTop=2, RectRight=3,
% 	RectBottom=4.
% 	
% 	[optional arguments]: Brackets in the function list, e.g. [color],
% 	indicate optional arguments, not matrices. Optional arguments must be in
% 	order, without omitting earlier ones, but you can use the empty matrix
% 	[] as a place holder, with the same effect as omitting it.
% 	
%	HALTING A PROGRAM
%
%	Mac:
%	Command-period halts any program. (Type a period "." while holding the
% 	apple-cloverleaf "command" key down.) If the command-period is
% 	intercepted by any of our MEX files, all of Screen's windows will be
% 	closed, and the cursor will be shown, to allow you to work normally in
% 	the Matlab Command window.
%
%	Win: 
% 	Ctrl-C halts any program.  (Type a "c" while holding down the "Ctrl"
% 	key.) If Ctrl-C is intercepted by any of our .dll files, the .dll file
% 	should exit, returning the user to the Matlab command window. However,
% 	this feature is not yet supported by all the Win Psychtoolbox functions.
% 	Additionally, Ctrl-C fails to halt progams executing in a Matlab process
% 	run with the "nojvm" option. To halt a runaway Psychtoolbox script in
% 	Win Psychtoolbox you might resort to the Windows Task Manager to kill
% 	the Matlab process.  (Use Ctrl-Alt-Delete to open a window from which
% 	you can start the Task Manager.)
%
%	BRINGING FORWARD THE COMMAND WINDOW
%
% 	Mac:
%	Command-zero brings the Matlab Command window forward. (Type a zero
% 	"0" while holding the apple-cloverleaf "command" key down.)
%
%	Win: 
% 	Ctrl-Alt-Delete allows you to launch the Windows task manager, which
% 	reduces the Psychtoolbox onscreen windows when it opens. (Simultaneosly
% 	press the "Ctrl", "Alt", and "Delete" keys.)  There also simpler ways of
% 	reducing the Psychtoolbox window which are specific to particular
% 	versions of Windows.
%   Windows 2000: 	Alt-Tab will bring another application to the foreground,
%					minimizing the Matlab Psychtoolbox window.
%   Windows NT: ??
%   Windows ME: ??
%   Windows 95 & 98: ??
% 
% 	WHEN YOU GET A MATLAB ERROR
% 
% 	If your computer only has one screen (the typical scenario) and your
% 	program produces a Matlab error while your full-screen window is open,
% 	you'll hear the beep, but you won't be able to see the Matlab Command
% 	Window. Follow the instructions above for brining forward the command
%	widow, then type clear screen to flush just the Screen MEX file, or 
%   "clear mex" to flush all the MEX files. When flushed, as part of its 
%   exit sequence, Screen closes all its windows, restores the screen's normal 
%   color table, and shows the cursor. Or you can get just those effects, 
%   without flushing, by calling 
%	Screen('CloseAll')
% 	You can use Matlab's EVAL command to do this for you automatically. E.g.
% 	if your program is called "foo.m", run your program by calling EVAL:
% 		eval('foo','clear screen;error(''error in foo'')')
% 	If an error occurs in FOO, Matlab, instead of halting, will execute the
% 	second argument to EVAL, which restores your screen and reports the
% 	error.
%
%	MOVIES ARE EASY
%
% 		% make movie
% 		window=Screen(0,'OpenWindow',0);
% 		rect=[0 0 200 200];
% 		for i=1:100
% 			movie(i)=Screen(window,'OpenOffscreenWindow',0,rect);
% 			Screen(movie(i),'FillOval',255,[0 0 2 2]*(i-1));
% 		end;
% 		% show movie
% 		for i=[1:100 100:-1:1] % forwards and backwards
% 			Screen('CopyWindow',movie(i),window,rect,rect);
% 			Screen(window,'WaitBlanking');
% 		end;
% 		Screen('CloseAll');
% 	
% 	See also ScreenDemo, MovieDemo, ScreenTest, PrepareScreen, RestoreScreen, PasteImage, CopyImage.
% 	
% 	BUGS
% 	All known bugs and fixes are eventually described at the web site on the Mac or Win page:
% 	web http://psychtoolbox.org/ ;
% 	Initial reports appear first at the forum:
% 	web http://www.yahoogroups.com/messages/psychtoolbox/ ;
% 	If you find a bug, please report it to the forum: 
% 	web mailto:psychtoolbox@yahoogroups.com ;
% 	It will help greatly if you can supply a  minimal-length program that exhibits 
% 	the bug. And please include a ScreenTest report to document the context in
% 	which you're running.
