function [wasSaveEnabled,wasDimEnabled]=ScreenSaver([enableSave,enableDim])
% [wasSaveEnabled,wasDimEnabled]=ScreenSaver([enableSave,enableDim])
% 
% ScreenSaver.mex controls AfterDark-compatible screen savers as well
% as Apple's Energy Saver screen dimming, allowing you to disable or
% enable screen saving and dimming. Most screen savers are
% AfterDark-compatible.
% 
% IMPORTANT: Note that as a result of a 9/99 enhancement to
% Screen.mex, you probably don't need to use ScreenSaver at all.
% Screen now automatically disables screen savers while it has
% onscreen windows open.
% 
% Please note that it's necessary to distinguish between "saving" and
% "dimming", even though both may look the same to you. Non-Apple
% companies have created a variety of screen "saving" programs that
% are (nearly) all controlled through one protocol. Apple provides an
% Energy Saver control panel that allows you to specify that the
% screen should be dimmed after a specified idle time. This is
% controlled through an entirely different mechanism.
% 
% Usually you'll want to save both states, as you set both to 0 and
% begin your experiment, and then restore both states when you're
% done. ScreenSaver makes that very easy to do.
% 
% All the input and output arguments can only have values 0 (false)
% and 1 (true). Screen saving or dimming may not be available, in
% which case they are considered to be off.
% 
% NOTE: If you use the screen saver Sleeper (as we do), please use
% version 3.2.1 or better, as in earlier versions the "Power down
% monitor" mode could not be enabled/disabled by another process.
% web http://www.stclairsoft.com/Sleeper/
% 
% ScreenSaver.mex is an enhanced replacement for the obsolete
% AfterDark.m. Please update your programs. In most cases you'll want
% to simply eliminate the call.
% 
% NOTE: The AfterDark 4.03 screen saver seems to be incompatible with
% Mac OS 9, e.g. AfterDark crashes when you close its control panel.
% This isn't too surprising since After Dark hasn't been updated
% since 1997. Instead, we recommend using the Energy Saver included
% in the Mac OS, which will save power as well as your screen. Or use
% Sleeper (link below), which is updated frequently and seems to be
% compatible with everything.
% 
% According to Rene Ros's Gestalt Selectors List, the following
% screen savers are AfterDark-compatible:
% AfterDark by Berkeley Systems, Inc.
% Arashi by Juri Munkki
% Basic Black by Mason L. Bliss
% BlackWatch by Ken McLoad
% CDU by Connectix Corp.
% Coffee Break by Thomas Reed
% DarkSide of the Macintosh by Tom Dowdy
% PixelPlay
% ScreenDaemon by Mason L. Bliss
% Sleeper by St. Clair Software
% web http://www.stclairsoft.com/Sleeper/               % we recommend Sleeper
% web http://www.rgaros.nl/gestalt/chapters/ch-11.html  % Rene Ros's Gestalt Selectors List
% 
% Also see ScreenSaverTest and "Screen OpenWindow?".

% 9/26/99 dgp  Wrote it, based on dhb's AD.mex and AfterDark.m.
% 9/28/99 dgp  Added list of supported screen savers.
% 12/23/99 dgp  Note that AfterDark is incompatible with Mac OS 9.
% 1/18/00 dgp  Enhanced to support Energy Saver.
% 1/21/00 dgp Recommend upgrading to Sleeper 3.2.1b6 or better.
% 7/11/00 dgp Cosmetic.
