function oldType = ShowCursor(type)
% oldType = ShowCursor([type])
%
% ShowCursor.mex asks the Macintosh OS to cancel one call to HideCursor.
% You must call ShowCursor at least as many times as you've called
% HideCursor before the cursor will appear. Excess calls to
% ShowCursor are ignored. (When Screen closes its last window it calls
% InitCursor which zeroes the count.)
%
% On Macintosh:
% If provided, the optional "type" argument changes the cursor shape to:
%   0: Arrow
%   1: I Beam
%   2: Cross
%   3: Plus
%   4: Watch
%   5: Arrow
% 128: P
% 300: Beachball 1/4
% 301: Beachball 2/4
% 302: Beachball 3/4
% 303: Beachball 4/4
% 400: fat arrow
% 401: fat I Beam
% Type 0 (and 5 for backward compatibility) is predefined as the standard 
% arrow cursor. The rest return whatever Apple's GetCursor(type) finds in the 
% System or Matlab's resource forks. If nothing is found, the type is reset to 0.
% The fat arrow and I beam are copied from the "Fat Cursors v 1.2" control
% panel created by Robert Abatecola, 5106 Forest Glen Drive, San Jose, CA 95129.
%
% On Windows, the cursor shape cannot be set yet.

% 7/23/97 dgp Cosmetic editing.
% 8/15/97 dgp Explain hide/show counter.
% 3/15/99 xmz Added comments for PC version.
% 8/19/00 dgp Cosmetic.
% 4/14/03 awi Added call to Screen('ShowCursor'...) for OS X.



%on OS X the Screen.mexmac shows the cursor, not 
%ShowCursor.mexmac.  ShowCursor.m wraps the 
%Screen call to emulate ShowCursor.mex
if strcmp(computer, 'MAC') 
    Screen('ShowCursor',0);
end 
