function result=Attenuator(command,varargin)
% Attenuator.mex (formerly "CLUT.mex") computes a color lookup table
% (clut) for use with a Pelli-Zhang video attenuator. It assumes that you
% have previously used the standalone application CalibrateLuminace to
% create a LuminanceRecord?.h file, which it reads in. CalibrateLuminance
% is included in the free VideoToolbox (link below).
% 
% Attenuator.mex reads in the file a LuminanceRecord?.h (where "?" is a screen
% number) from the current directory, and allows you to access the more
% important calls in the VideoToolbox's Luminance.c to prepare a ColorSpec
% array, stored as a Matlab array (256 rows, 3 columns). Use Screen
% 'SetClut' to load the Matlab colorSpecs array into the video hardware
% clut of your screen.
% 
% text=Attenuator('ReadLuminanceRecord',screenNumber);
% 	Looks for the file "LuminanceRecord?.h", where "?" is the screenNumber,
% 	in the current directory: pwd,dir. screenNumber 0 is the main screen, 
% 	1 is the next, and so on. 
% 
% specs=Attenuator('GetSpecs');
% 	Returns a struct containing various useful numbers (including
% 	LMin,LMax,LBackground,dpi,Hz,dacSize) from the LuminanceRecord, either
% 	as a struct (recommended), or as an explicit list of return values (not
% 	shown, less convenient).
% 
% clut=Attenuator('SetLuminances',firstEntry,lastEntry,LMin,LMax,[oldClut]);
% 	Creates a new 256x3 colorSpecs array, i.e. color lookup table (clut).
% 	Initializes it by copying the optional oldClut argument, if it's
% 	present. Then sets the specified range of entries to produce as nearly
% 	as possible a linear ramp over the specified luminance range. 
%	(Unspecified entries will retain the values from oldClut.) Entries
% 	are numbered 0:255.
% 
% luminance=Attenuator('GetLuminance',entry,clut);
% 	Returns the luminance that will be produced by the specified entry of
% 	the supplied colorSpec array. Entries are numbered 0:255.
% 
% [clut,luminance]=Attenuator('IncrementLuminance',entry,oldClut);
% 	Increments the specified entry of oldClut by the smallest
% 	possible nonzero amount. Optionally returns the new luminance that will
% 	be produced by that entry. Entries are numbered 0:255.
% 
% Also see Screen SetClut and AttenuatorTest.
% 
% FUTURE
% 
% Attenuator.mex and CalibrateLuminance have been very carefully tested
% and are perfectly accurate. However, CalibrateLuminance is clumsy to
% use. Both programs are needlessly restricted to the Mac. It would be
% better, for many reasons, to replace them by platform-independent Matlab
% M files. We don't have any timetable for doing this, as the current
% programs, however clunky, are serving our needs well. But anyone can
% jump in here and do it. All the ideas are in the Pelli and Zhang (1991)
% article, and the C sources for Attenuator.mex and CalibrateLuminance are
% available.
% 
% REFERENCES
% 
% D.G. Pelli and L. Zhang (1991) Accurate control of contrast on
% microcomputer displays. Vision Research, 31:1337-1360.
% 
% Attenuator web page
% web http://vision.nyu.edu/Tips/Attenuator.html ;
% 
% CalibrateLuminance (application and sources are in VideoToolbox)
% web http://vision.nyu.edu/VideoToolbox/Contents.html ;
% web http://vision.nyu.edu/VideoToolbox/Download.html ;
% 
% 1/19/97 dgp Wrote it.
% 4/14/02 dgp Added disclaimer and references.
