% AttenuatorTest.m
%
% Exercise Attenuator.mex.

% 4/14/96 dgp Wrote it.
% 1/19/96 dgp Updated for new Matlab 5 version.
% 4/14/02 dgp Updated for new struct return argument from 'GetSpecs'
% 4/15/02 dgp Set directory.
% 6/29/02 dgp Use PsychtoolboxRoot to cope with user-changed folder name.

if ~strcmp(computer,'MAC2')
	error('Sorry, Attenuator.mex is currently Mac-only. We hope someone will rewrite it as a platform-independent M file.');
end

screenNumber=9;
cd(fullfile(PsychtoolboxRoot,'PsychBeta','Attenuator',''));
text=Attenuator('ReadLuminanceRecord',screenNumber);
disp(text);
rec=Attenuator('GetSpecs');
disp(sprintf('LMin %.1f, LMax %.1f, LBackground %.1f, %.0f dpi, %.1f Hz, %d bits',rec.LMin,rec.LMax,rec.LBackground,rec.dpi,rec.Hz,rec.dacSize));
firstEntry=0;
lastEntry=255;
colorSpecs=Attenuator('SetLuminances',firstEntry,lastEntry,rec.LMin,rec.LMax);
entry=127;
luminance=Attenuator('GetLuminance',entry,colorSpecs)
[colorSpecs,luminance]=Attenuator('IncrementLuminance',entry,colorSpecs);
luminance
