/* This LuminanceRecord9.h file is a description of a monitor produced by the CalibrateLuminance program. */
/* This file may be #included in any C program. It simply fills in a LuminanceRecord data structure. */
/* Or use ReadLuminanceRecord.c to read this file at runtime. */
/* The theory is described by Pelli & Zhang (1991). The data structure is defined in Luminance.h.  */
/* CalibrateLuminance and Luminance.h are part of the VideoToolbox software. */
/* Pelli & Zhang (1991) Accurate control of contrast on microcomputer displays. */
/* Vision Research, 31:1337-1360. */
/* The VideoToolbox software is available from: */
/* ftp://mirrors.aol.com/pub/info-mac/dev/lib/video-toolbox */
/* Caution: the screen number used here and in GetScreen Device is NOT the same as */
/* displayed by the Monitors cdev in the Control Panel. */
LR.screen=9; /*device=GetScreenDevice(LR.screen);*/
LR.id="brightview";
LR.name="brightview";
LR.date="11:37 AM Thursday, August 16, 2001";
LR.notes="Marialuisa with fluorescent off";
LR.dacSize=8;
LR.LMin=7.114166259765625; /*luminance at VMin*/
LR.LMax=629.096267700195312; /*luminance at VMax*/
LR.LBackground=172.263381958007812; /*background luminance during calibration*/
LR.VBackground=144; /*background number used during calibration*/
LR.dpi=76; /*pixels/inch*/
LR.Hz=75.4539023815137939; /*frames/second*/
LR.units="cd/m^2";
LR.coefficients=9; /*# of coefficients in polynomial fit*/
LR.p[0]=9.30382859766452425e-27;LR.p[1]=5.21023035309798476e-18;
    LR.p[2]=-4.93692206896225918e-21;LR.p[3]=1.92091189761720732e-22;
    LR.p[4]=3.36157606017998138e-20;LR.p[5]=5.6274817607656583e-18;
    LR.p[6]=8.46367126418199256e-16;LR.p[7]=9.63503162345648312e-14;
    LR.p[8]=-3.45626209003621295e-16;
     /*L(V)=p[0]+p[1]*V+p[2]*V*V+ . . . polynomialError*/
LR.polynomialError=64.1796507008401077; /*RMS error of fit*/
LR.q[0]=14.4648370742797852;LR.q[1]=-0.554027140140533447;
    LR.q[2]=0.0115501768887042999;
     /*L(V)=q[0]+q[1]*V+q[2]*V*VquadraticError*/
LR.quadraticError=4.76593588174800588; /*RMS error of fit*/
LR.power[0]=7.11416816711425781;LR.power[1]=-0.613961338996887207;
    LR.power[2]=0.073684990406036377;LR.power[3]=2.21818137168884277;
     /*L(V)=power[0]+Rectify(power[1]+power[2]*V)^power[3]powerError */
    /* where Rectify(x)=x if x0, and Rectify(x)=0 otherwise. */
    /* Pelli & Zhang (1991) Eqs.9&10 use symbols v=V/255, */
    /* alpha=power[0], beta=power[1], kappa=power[2]*255, gamma=power[3]*/
LR.powerError=2.26070522133926699; /*RMS error of fit*/
LR.fixedPower[0]=5.84832572937011719;LR.fixedPower[1]=-0.178407773375511169;
    LR.fixedPower[2]=0.0666724145412445068;
    LR.fixedPower[3]=2.27999997138977051;
     /*L(V)=fixedPower[0]+Rectify(fixedPower[1]+fixedPower[2]*V)^fixedPower[3]fixedPowerError */
    /* The exponent fixedPower[3] is fixed.*/
LR.fixedPowerError=1.94694613839117514; /*RMS error of fit*/
LR.r=0.0335605361387868022;
LR.g=0.155079094082230537;
LR.b=0.81136036977898266;
LR.gainAccuracy=-0.00222328230796155516;
LR.gm=1.98626164615770135; /*The monitor's contrast gain.*/
LR.rangeSet=0; /*zero indicates that range parameters have yet to be set*/
LR.L.exists=0; /*zero indicates that luminance table has yet to be initialized*/
LR.VMin=0; /*minimum value that can be loaded into DAC*/
LR.VMax=255; /*maximum value that can be loaded into DAC*/

