% BItsSimpleTest
%
% Simple test of Bits++ interface when it is in its Mono++
% mode.
%
% 9/13/02 dhb
% 2/26/03 dhb  Force on-card CLUT to be a identity mapping.
% 9/20/03 dhb  No more calls to MEX file.

% Define screen
whichScreen=1;

% Open window fill frame buffer with zeros
[window,screenRect] = Screen(whichScreen,'OpenWindow',0,[],32);
SCREEN(window,'SetClut',(0:255)'*ones(1,3));
monoImage = BitsPlusPackMonoImage(2^16-1*ones(300,300));
SCREEN(window,'PutImage',monoImage);
GetChar;

% Use BITS++ to set uniform lookup tables of increasing values.
% Hit key to proceed through. Screen intensity should increase
% monotonically, but does not.  Also note very slow CLUT write time.
for colorval = round(linspace(0,2^14-1,20))
	uniclut = colorval*ones(256,3);
	fprintf('Setting to value %g\n',colorval);
	BitsPlusSetClut(window,uniclut);
	GetChar;
end

% Close the window.
Screen(window,'Close');

% Blank the screen
BitsPlusBlank(whichScreen);



