function BitsPlusSetClut(windowPtr,clut)
%  BitsPlusSetClut(windowPtr,clut)
% 
% Set a lookup table, slowly but in a self contained
% fashion.
% 
% Prior to using this routine, Bits++ box must be in
% framebuffer load mode.
%
% 2/28/03   dhb, ptw  Wrote it.

% Get bits rectangle and unlock code
bitsPlusRect = [0 0 524 1];

% Open offscreen memory to store old clut
offWindow = SCREEN(windowPtr,'OpenOffscreenWindow',0,bitsPlusRect);

% Write it into offscreen memory
newClutRow = BitsPlusEncodeClutRow(clut);
Screen(offWindow,'PutImage',newClutRow,bitsPlusRect);

% Copy it fast and in sync with video blanking
Screen(windowPtr,'WaitBlanking');
WaitSecs(0.003);
Screen('CopyWindow',offWindow,windowPtr,bitsPlusRect,bitsPlusRect);

% Close up offscreen memory
Screen(offWindow,'Close');
