% function Crowding
% Create a list of letters, and display them.
% 
% IMPORTANT: turn off font smoothing!
% In Control Panel ~ATM, uncheck "Smooth Font Edges on Screen".
% In Control Panel Appearance, select Fonts tab, and uncheck "Smooth all fonts on screen".
% 
% Each letter is drawn horizontally centered over specified baseline point.

% 8 September 2002, Denis Pelli, denis.pelli@nyu.edu

% Prepare list of letters
whichScreen=max(Screen('Screens'));
viewingDistanceCm=400;
screenWidthCm=30; % measured width of screen, from leftmost to rightmost pixel.
[w,r]=Screen(whichScreen,'OpenWindow');
[ww,rr]=Screen(w,'OpenOffscreenWindow',[],r);
www=Screen(w,'OpenOffscreenWindow'); % scratch
font='Sloan';
screen(w,'TextFont',font);
screen(ww,'TextFont',font);
screen(www,'TextFont',font);
pixelsPerDeg=1/(57*screenWidthCm/rr(RectRight)/viewingDistanceCm);
for i=1:4
	list(i).sizeDeg=1; % letter size (deg)
end
list(1).letter='C'; % the letters you want to show.
list(2).letter='D';
list(3).letter='H';
list(4).letter='K';
spacingDeg=2;
% yDeg increases upward. xDeg increases rightward. Both are relative to fixation.
list(1).xDeg=-spacingDeg/2; % the horizontal ecc. (deg)
list(1).yDeg=spacingDeg/2;  % the vertical ecc. (deg)
list(2).xDeg=spacingDeg/2;
list(2).yDeg=spacingDeg/2;
list(3).xDeg=-spacingDeg/2;
list(3).yDeg=-spacingDeg/2;
list(4).xDeg=spacingDeg/2;
list(4).yDeg=-spacingDeg/2;
for i=1:length(list)
	list(i).yDeg=list(i).yDeg-list(i).sizeDeg/2; % move down 1/2 letter height
end
% yDeg increases upward. xDeg increases rightward. 
fixation.xDeg=0; % location of fixation (deg), relative to center of screen
fixation.yDeg=0; %
fixation.sizeDeg=0.1; % width (and height) of fixation cross (deg).

% Display fixation cross
[fixationX,fixationY]=RectCenter(rr);
fixationX=fixationX+fixation.xDeg*pixelsPerDeg;
fixationY=fixationY-fixation.yDeg*pixelsPerDeg;
rect=[0 0 fixation.sizeDeg fixation.sizeDeg] * pixelsPerDeg;
rect=CenterRectOnPoint(rect,fixationX,fixationY);
thickness=pixelsPerDeg*fixation.sizeDeg/8; % width of lines in fixation cross.
Screen(ww,'DrawLine',[],rect(1),fixationY,rect(3),fixationY,thickness,thickness);
Screen(ww,'DrawLine',[],fixationX,rect(2),fixationX,rect(4),thickness,thickness);
Screen('CopyWindow',ww,w,rr,rr);
WaitSecs(1);

% Display the list of letters
% Note that "y" is in pixels and increases downward, unlike "yDeg".
textSize=50; % arbitrary size, just for calibration
Screen(www,'TextSize',textSize);
width=Screen(www,'TextWidth','O');
letterWidthPerSize=width/textSize;
for i=1:length(list)
	textSize=list(i).sizeDeg*pixelsPerDeg/letterWidthPerSize;
	Screen(ww,'TextSize',textSize);
	Screen(www,'TextSize',textSize);
	width=Screen(www,'TextWidth',list(i).letter);
	x=list(i).xDeg*pixelsPerDeg-width/2;
	y=-list(i).yDeg*pixelsPerDeg;
	Screen(ww,'DrawText',list(i).letter,x+fixationX,y+fixationY);
end
Screen('CopyWindow',ww,w,rr,rr);

% Wait for response
Screen(w,'TextSize',36);
Screen(w,'TextFont','Verdana');
Ask(w,'Click to continue',GrayIndex(w,0.5));
Screen('CloseAll');
