function LetterPhaseDemo
% Demo for 7/02 NEI grant proposal.
% Display letter with scrambled phase.
% I find that I can identify better than chance,
% especially with peripheral viewing.

% 7/8/02 dgp Wrote it.

checkPix=1;
waitForClick=0;
saveToDisk=0;
rmsContrast=0.0;
cellWidthPix=80/checkPix;
rows=1;
columns=1;
chartWidthPix=columns*cellWidthPix;
cellHeightPix=cellWidthPix;
chartHeightPix=rows*cellHeightPix;
rect=[0 0 chartWidthPix chartHeightPix];
window=screen(0,'OpenWindow',128,[],8);
wide=1;
for wide=0
	for letterChart=1
		% 	fprintf('free %.1f MB;temp free %.1f MB\n',bytes/1e6,bytes('tempfree')/1e6);
		windowRect=screen(window,'Rect');
		Screen(window,'TextSize',32);
		w=screen(window,'openoffscreenwindow',[],rect,8);
		ww=screen(window,'openoffscreenwindow',[],rect,8);
		% 	w=screen(-1,'openoffscreenwindow',[],rect,8);
		% 	ww=screen(-1,'openoffscreenwindow',[],rect,8);
		srcRect=Screen(ww,'Rect');
		dstRect=checkPix*OffsetRect(srcRect,wide*chartWidthPix,(~letterChart)*chartHeightPix);
		dstRect=OffsetRect(dstRect,RectWidth(dstRect),RectHeight(dstRect)); % move letter away from edge of screen
		noiseOriginal=rand([chartHeightPix chartWidthPix ])-0.5; % zero mean
		for column=1:columns
			noise=noiseOriginal;
			filter=Bandpass2(size(noise),0,1);
			if any(any(filter~=1)) % skip all-pass filter
				noise=filter.*fftshift(fft2(noise));
				noise=real(ifft2(ifftshift(noise)));
			end
			power=mean(mean(noise.^2));
			noise=noise*rmsContrast/sqrt(power);
			
			% convert to integers
			noise=round(127+noise*255);
			bad=length(find(noise<0 | noise>255));
			total=length(noise(:));
			if bad/total>0.01
				fprintf('%.1f%% of out-of-bounds pixels (%g/%g) will be clipped.\n',100*bad/total,bad,total);
			end
			noise=min(255,max(0,noise));
			
			Screen(w,'PutImage',noise);
			columnRect=[0 0 cellWidthPix chartHeightPix];
			columnRect=OffsetRect(columnRect,cellWidthPix*(column-1),0);
			Screen('CopyWindow',w,ww,columnRect,columnRect);
			Screen('CopyWindow',ww,window,srcRect,dstRect);
		end
		Screen(w,'FillRect');
		Screen(w,'TextFont','Sloan');
		Screen(w,'TextSize',cellHeightPix/2);
		for column=1:columns
			for row=1:rows
				cellRect=[0 0 cellWidthPix cellHeightPix];
				cellRect=OffsetRect(cellRect,cellWidthPix*(column-1),cellHeightPix*(row-1));
				letterRect=cellRect/2;
				letterRect=CenterRect(letterRect,cellRect);
				c=2^(-(row+4)/2);
				if letterChart
					c=c*2;
				end
				color=round(c*128);
				if letterChart
					theLetter=Sample('CDHKNORSVZ')
					Screen(w,'DrawText',theLetter,letterRect(RectLeft),letterRect(RectBottom),color);
					letter=Screen(w,'GetImage',cellRect);
					dc=mean(mean(letter));
					filter=Bandpass2(size(letter),0,1);
					if any(any(filter~=1)) % skip all-pass filter
						letter=filter.*fftshift(fft2(letter));
						% convert to phase & amplitude, and back
						amp=abs(letter);
						phase=angle(letter);
						phase=2*pi*rand(size(phase));
						letter=amp.*exp(sqrt(-1)*phase);
						letter=real(ifft2(ifftshift(letter)));
					end
					letter=dc+letter-mean(mean(letter)); % restore original dc
					Screen(w,'PutImage',letter,cellRect);
				else
					c=c;
					color=round(c*128);
					if row==1
						dc=color;
					end
					[x,y]=meshgrid(1:cellWidthPix,1:cellHeightPix);
					grating=sin(2*0.5*2*pi*y/(cellHeightPix/6)).*exp(-((x-cellWidthPix/2)/(cellWidthPix/3)).^2-((y-cellHeightPix/2)/(cellHeightPix/3)).^2);
					Screen(w,'PutImage',color*grating+dc,cellRect); % add temporary dc offset, removed below.
				end
			end
		end
		Screen('CopyWindow',w,ww,[],[],'addOverQuickly'); % add signal to noise
		if ~letterChart
			% remove the temporary dc offset from grating
			Screen(ww,'PutImage',(256-dc)*ones(chartHeightPix,chartWidthPix),srcRect,'addOverQuickly');
		end
		Screen('CopyWindow',ww,window,srcRect,dstRect);
		if saveToDisk
			% save to disk
			rect=Screen(ww,'Rect');
			paperRect=SetRect(0,11*72,8.5*72,0);
			pageRect=rect.*[1,-1,1,-1];% convert from Apple to Adobe coordinates
			pageRect=CenterRect(pageRect,paperRect);
			if wide
				insert='Bw';
			else
				insert='';
			end
			if letterChart
				filename=sprintf('LetterVsOrientation%s.eps',insert);
			else
				filename=sprintf('GratingVsOrientation%s.eps',insert);
			end
			cd(DesktopFolder);
			Screen(ww,'SaveAsEps',filename,rect,pageRect)
			filetype(filename,'EPSF','GKON'); % set creator to GraphicConverter <http://www.lemkesoft.com/gcdownload_us.html>
			fprintf('Saving "%s" on desktop.\n',filename);
		end
		if waitForClick
			Ask(window,'Click to continue.');
		end
		Screen(w,'Close');
		Screen(ww,'Close');
	end
end
Ask(window,'Done. Click to exit.');
Screen(window,'Close');
