function qdbug
% This crashes to MacsBug in ScreenOpenOffscreenWindow on my PowerMac G3/300.

letterBandwidth=60;
checkPix=1;
saveToDisk=1;
rmsContrast=0.1;
cellWidthPix=80/checkPix;
rows=7;
columns=3;
chartWidthPix=columns*cellWidthPix;
cellHeightPix=cellWidthPix;
chartHeightPix=rows*cellHeightPix;
rect=[0 0 chartWidthPix chartHeightPix];
window=screen(0,'OpenWindow',[],[],8);
% 	fprintf('free %.1f MB;temp free %.1f MB\n',bytes/1e6,bytes('tempfree')/1e6);
windowRect=screen(window,'Rect');
Screen(window,'TextSize',32);
w=screen(-1,'openoffscreenwindow',[],rect,8);
ww=screen(-1,'openoffscreenwindow',[],rect,8);
srcRect=Screen(ww,'Rect');
dstRect=checkPix*OffsetRect(srcRect,chartWidthPix,0);
noiseOriginal=rand([chartHeightPix chartWidthPix ])-0.5; % zero mean
for column=1:columns
	noise=noiseOriginal;
	oLow=90-0.5*180*column/columns;
	oHigh=90+0.5*180*column/columns;
	filter=OrientationBandpass(size(noise),oLow,oHigh);
	filter=filter.*Bandpass2(size(noise),0,1);
	noise=filter.*fftshift(fft2(noise));
	noise=real(ifft2(ifftshift(noise)));
	power=mean(mean(noise.^2));
	noise=noise*rmsContrast/sqrt(power);
	
	% convert to integers
	noise=round(127+noise*255);
	total=length(noise(:));
	noise=min(255,max(0,noise));
	
	Screen(w,'PutImage',noise);
	columnRect=[0 0 cellWidthPix chartHeightPix];
	columnRect=OffsetRect(columnRect,cellWidthPix*(column-1),0);
	Screen('CopyWindow',w,ww,columnRect,columnRect);
	Screen('CopyWindow',ww,window,srcRect,dstRect);
end
Screen(w,'FillRect');
Screen(w,'TextFont','Sloan');
Screen(w,'TextSize',cellHeightPix/2);
for column=1:columns
	for row=1:rows
		cellRect=[0 0 cellWidthPix cellHeightPix];
		cellRect=OffsetRect(cellRect,cellWidthPix*(column-1),cellHeightPix*(row-1));
		letterRect=cellRect/2;
		letterRect=CenterRect(letterRect,cellRect);
		c=2^(-(row+4)/2);
		c=c*2;
		color=round(c*128);
		Screen(w,'DrawText',Sample('CDHKNORSVZ'),letterRect(RectLeft),letterRect(RectBottom),color);
		if letterBandwidth<180
			letter=Screen(w,'GetImage',cellRect);
% 			dc=mean(mean(letter));
% 			oLow=90-0.5*letterBandwidth;
% 			oHigh=90+0.5*letterBandwidth;
% 			filter=OrientationBandpass(size(letter),oLow,oHigh);
% 			filter=filter.*Bandpass2(size(letter),0,1);
% 			if any(any(filter~=1)) % skip all-pass filter
% 				letter=filter.*fftshift(fft2(letter));
% 				letter=real(ifft2(ifftshift(letter)));
% 			end
			Screen(w,'PutImage',letter,cellRect);
		end
	end
end
Screen('CopyWindow',w,ww,[],[],'addOverQuickly'); % add signal to noise
Screen('CopyWindow',ww,window,srcRect,dstRect);
if saveToDisk
	% save to disk
	rect=Screen(ww,'Rect');
	paperRect=SetRect(0,11*72,8.5*72,0);
	pageRect=rect.*[1,-1,1,-1];
	pageRect=CenterRect(pageRect,paperRect);
	insert='Bw';
	filename=sprintf('LetterVsOrientation%s.eps',insert);
	cd(DesktopFolder);
	Screen(ww,'SaveAsEps',filename,rect,pageRect)
	filetype(filename,'EPSF','GKON'); 
	fprintf('Saving "%s" on desktop.\n',filename);
end
Screen(w,'Close');
Screen(ww,'Close');
Ask(window,'Done. Click to exit.');
Screen(window,'Close');
