function SetClut(windowPtr,clut,suppressWait)
% SetClut(windowPtr,clut,[suppressWait])
% 
% OBSOLETE: SetClut and the other files in the PsychBeta:TenBitInterface
% directory represent an initial attempt to provide support for 10-bit
% DACs. It was successful, but has been superceded by a more universal
% solution provided by LoadClut. Please use LoadClut.
% 
% Load the hardware CLUT. Works with 8-or-more-bit-DAC graphics cards.
% The Radius Thunder, ATI Radeon, and perhaps NVIDIO, have 10-bit DACs.
% The BITS++ adapter from Cambridge Research Systems has 14-bit DACs.
% http://www.crsltd.com/catalog/bits++/
% 
% SetClut only allows you to write the entire clut, not portions of it.
% Use SetColor to write just one entry.  Your window must have been opened
% with OpenWindow for this routine to work properly.
% 
% If SetClut is called with suppressWait==1, then any explicit calls to
% Screen('WaitBlanking') are suppressed.  This will not suppress any
% implicit calls in Screen('SetClut') which may or may not be enabled
% depending on the exact card/driver/initialization used.
% 
% The first time SetClut is called, it takes some time to initialize.
% Therefore it should be called at least once before use in time-critical
% loops. These variables are shared with routine SetColor, so that may
% also be called to initialize the variables for this one.
% 
% To load all 10 bits of the hardware CLUT on 10-bit-DAC cards it is
% necessary to use the Gamma call. The gamma table argument in the Gamma
% call is used only by the software driver. The driver uses the current 
% "gammma" table to transform the "clut" table provided in each SetClut call
% to produce a transformed table that it loads into the hardware CLUT.
% 
% The loading of the hardware CLUT is achieved slightly differently
% depending on the pixelsize. In 8 (or less)-bit-pixel mode, the call to
% Gamma merely replaces the driver's software gamma table, without
% touching the hardware CLUT, so we call SetClut after Gamma to load the
% hardware CLUT. In 16- or 32-bit-pixel mode, the call to Gamma causes
% the hardware CLUT to be loaded immediately, so we precede the call to
% Gamma by a Screen('WaitBlanking') call.
% 
% For 8-bit-DAC cards, SetClut just calls Screen(windowPtr,'SetClut',...).
% For 10-bit-DAC cards, SetClut attempts to sync the write to the vertical
% blanking.
% 
% WARNING: Apple's release notes for Mac OS 9.1 warn that "The Color Manager 
% has been changed so that requests for white and black on 8 bit devices 
% now use the documented requirement that white is the first entry in the 
% palette and black the last entry. This will cause problems if 
% applications have custom palettes which do not have white and black in 
% these required positions."
% web http://developer.apple.com/technotes/tn/tn2010.html ;
% 
% Our understanding of this warning is that it's meant quite literally.
% The Mac OS (i.e. QuickDraw) cares about the values in the software
% Palette maintained by QuickDraw for your screen. It does not know or
% care what values you ask the driver to put into the hardware CLUT.
% 
% See also OpenWindow, SetColor, CloseWindow, ScreenDacBits, ScreenUsesHighGammaBits.

% 8/22/00  dhb    Wrote it.
% 10/3/01  bds		Changed RADIUS to GAMMA10 to include RADEON since it acts like RADIUS.
% 1/25/02  dhb    Incorporate bds changes into master version.
% 2/01/02  dhb    Remove bits_SetColor, add GAMMA10.clut.  Logic rewrite. 
% 2/28/02  dhb,ly,kr  Deal with high 10-bit cards.
% 3/20/02  dgp	  Cosmetic.
% 3/21/02  dgp	  Added note above about Mac OS 9.1 Color Manager assumptions about 
%									the 8-bit CLUT.
% 7/9/02   dhb    Just call through LoadClut.  Ignore suppresWait.
% 7/11/02  dgp    Added our interpretation of WARNING, above.

LoadClut(windowPtr,clut);

% global GAMMA10 % static cache
% 
% if nargin<3 | isempty(suppressWait)
% 	suppressWait = 0;
% end
% screenNumber=Screen(windowPtr,'WindowScreenNumber');
% screenIndex=screenNumber+1;
% if ~exist('GAMMA10','var') | ~isfield(GAMMA10,'openWindowTrue') | isempty(GAMMA10.openWindowTrue) | ~GAMMA10.openWindowTrue(screenIndex)
% 	error('SetClut: window not opened by OpenWindow');
% end
% 
% dacBits=ScreenDacBits(screenNumber);
% if dacBits==8
% 	% 8 bit DACs: 
% 	Screen(windowPtr,'SetClut',clut);
% else
% 	% 8+ bit DACs: 
% 	if ScreenUsesHighGammaBits(windowPtr)
% 		clut = bitshift(clut,16-dacBits);
% 	end
% 	pixelSize = Screen(windowPtr,'PixelSize');
% 	switch(pixelSize)
% 	case 32,
% 		if ~suppressWait
% 			Screen(windowPtr,'WaitBlanking');
% 		end
% 		Screen(windowPtr,'Gamma',clut,dacBits);
% 		break;
% 	case 8,
% 		Screen(windowPtr,'Gamma',clut,dacBits);
% 		if IsATIRadeon10(windowPtr) & ~suppressWait
% 			Screen(windowPtr,'WaitBlanking');
% 		end
% 		Screen(windowPtr,'SetClut',GAMMA10.clut{screenIndex});
% 	otherwise,
% 		error(sprintf('SetClut: current pixelSize %g not supported',pixelSize));
% 	end
% end
