% TestNewSetClut
%
% Will create a gray ramp with 256 gray values using
% the new SetClut.m, IsRadius10.m, and IsRadeon10_*.m.
% The gray values will span the minimum contrast
% available, so on a Radius or Radeon with the right drivers
% their 10 bit DACs will be exploited to produce a ramp which
% has 1/4 the contrast of a card with 8 bit DACs.
%
% 10/3/01  bds  Wrote it
% 3/15/02  bds	Updated for new SetClut/IsRadeon10*/OpenWindow by dhb
% 4/2/02   bds	Removed redundant 1st-gen bitshift since SetClut now does it, use Is10Bit,
%				and explicitly set color depth in OpenWindow call, which requires it

screenNumber = 0;
help TestNewSetClut;
[w,r] = OpenWindow(screenNumber,128,[],32);
clut = repmat([0:255]',1,3);
fprintf('Using %d bit DACs\n',ScreenDacBits(w));
if ScreenDacBits(w)>8
	clut = clut + 384;
	if IsATIRadeon10(w)
		disp('[Radeon 1st generation]');
	elseif IsATIRadeon10Gen2(w)
		disp('[Radeon 2nd generation]');
	else
		disp('[Radius Thunder]'); % Radius, Radeon 2nd Gen uses lower 10 bits
	end
end
	
SetClut(w,clut);
Screen(w,'PutImage',repmat([0:255],200,1));
disp('press any key');
getchar;
CloseWindow(w);

