function clut = MakeBitClutBP(plane,offColor,onColor)
% clut = MakeBitClutBP(plane,offColor,onColor)
%
% Set up clut to show one bit plane of an 8-bit frame buffer
% as a binary image. The binary image is shown as offColor
% and onColor.
%
% This code would be cleaner if I could remember what
% Matlab's methods for logical bit operations were.
%
% 4/8/97  dhb  Wrote it.
% 4/8/02  awi  Rewrote for clarity.  

% OLD VERSION
% clut = ones(256,1)*offColor;
% for i = 1:256
% 	toTest = floor((i-1)/(2^(plane-1)));  
% 	if (2*floor(toTest/2) ~= toTest)
% 		clut(i,:) = onColor;
%     end
% end

%NEW VERSION
clut = ones(256,1)*offColor;
planeBitValue = 2^(plane-1);
clutPlaneRows = find(bitand(planeBitValue,[0:255])== planeBitValue);
for i = clutPlaneRows
    clut(i,:) = onColor;
end;
