% Psychtoolbox:PsychDemos.
%
% help Psychtoolbox % For an overview, triple-click me & hit enter.
%
% These demos show how to use the Psychophysics Toolbox. Run a demo, see
% what it does, and then look at the code: e.g. type "edit moviedemo" to
% look at MovieDemo.m. SCREENDEMO is a good first choice. It demonstrates
% much of the basic functionality. MOVIEDEMO is very simple, yet
% demonstrates everything you need to show arbitrary images, one per
% frame, at 75 Hz, or whatever rate your monitor runs at.  (And run
% ScreenTest in PsychTests.)
% 
% TIP: If you're going to run many of these demos, you may find it
% convenient to copy the list into a new window. Double-click to select a
% test; hit enter to run it.
% 
% The "Use" column stars (*) particularly informative demos, and indicates
% which platforms (Mac and Win) are supported.
%
%   Demo                      Use    Description
%
%   ActiveWireDemo             M W  Control PicoStar's USB ActiveWire i/o device.  
%   BitPlaneDemo               M W  Use 8-bit frame buffer to hold 8 binary images.
%   ClutMovieDemo              M W  Show a movie using lookup-table animation.
%   ColorGratingDemo         * M W  Show a flickering full color grating.
%   ContrastThreshDemo         M W  Measure contrast thresholds in noise.
%   DialogDemo                 M    Use dialog box to get typed user response.
%   DriftDemo                * M W  Display a drifting grating.
%   ErrorCatchDemo             M W  Show how to code defensively against errors in M-file code.
%   EpsDemo                    M W  Save an image (a grating in noise) to disk.
%   FitGammaDemo               M W  Demonstrate gamma fitting routine FitGamma.
%   FontDemo                   M W  Shows how to find the font you want.
%   GammaFlipDemo              M    Flip screen gamma and clut.
%   GetNumberDemo              M W  Get number or string from user.
%   GratingDemo              * M W  Display a grating, at any pixelSize.
%   IsomerizationsInDishDemo   M W  Compute photoreceptor isomerizations for retina in a dish.
%   IsomerizationsInEyeDemo    M W  Compute photoreceptor isomerizations for human eye.
%   JoystickDemo               M    Read any USB joystick.
%   KbDemo                   * M W  Realtime keyboard monitoring, using KbCheck.
%   LineDemo                   M W  Use antialiasing to draw a smooth line, no jaggies.
%   MouseTraceDemo             M W  Track mouse around screen and draw contour.
%   MovieDemo                * M W  Make a movie.
%   MovieDemo2                 M W  Make a movie. A more elaborate example.
%   MovieTearDemo              M W  Demonstrates the artifact called "tearing".
%   NoiseDemo                * M W  Display dynamic white noise.
%   NomogramDemo               M W  Compute photoreceptor nomograms.
%   OffscreenDemo              M W  Draw and copy on- and off-screen.
%   PhaseDistortDemo           M W  Measure phase-distort. thresh. for face recognition.
%   QuestDemo                * M W  Simulate QUEST threshold measurement.
%   RenderDemo                 M W  Render CIE xyY as a color patch.
%   ScreenDemo               * M W  Show off some of Screen's many display functions.
%   ShowtimeDemo               M    Use Showtime.mex (formerly "QT.mex") to create a QuickTime movie.
%   SimpleCalDemo              M W  Exercise the calibration routines.
%   SpriteDemo               * M W  Animate a moving sprite.  
%   TextDemo                   M W  Display text in all fonts and sizes.
%   ValetonVanNorrenDemo       M W  Exercise our code that implements the V-VN (1983) cone adaptation model.
%   VisualGammaDemo            M W  Use visual matching to measure monitor's gamma.
%   WindowDemo                 M    Move windows around.
%   ZonePlateDemo              M W  View zone plate to assess monitor's gamma correction.
