% MakeNoisesCT
%
% Make two noise waveforms, one for each interval.
%
% 3/8/97  dhb  Pulled dgp's code out into this routine.
%              Eliminated bandpass options to simplify.

% Calculate noisePowerFactor
noiseBound=2;
x=-noiseBound:.001:noiseBound;
pdf=exp(-0.5*x.^2);
noisePowerFactor=sum(pdf.*x.^2)/sum(pdf);
clear x pdf;

% Make noises
maxNoiseCon=-Inf;
minNoiseCon=Inf;
for interval=1:nIntervals
	noise=randn(size(signal1));
	while (1)
		elements=find(noise<-noiseBound | noise>noiseBound);
		if isempty(elements);break;end;
		noise(elements)=randn(size(elements));
	end
	noise=noise*(noiseRmsContrast/sqrt(noisePowerFactor));
	maxNoiseCon=max(maxNoiseCon,max(max(noise)));
	minNoiseCon=min(minNoiseCon,min(min(noise)));
	eval(sprintf('noise%d=noise;',interval));
end

% Figure out how much headroom we have for the signal
maxDeviceCon = (LMax-LBackground)/LBackground;
minDeviceCon = (LMin-LBackground)/LBackground;
maxSignalCon = maxDeviceCon-maxNoiseCon;
minSignalCon = minDeviceCon-minNoiseCon;
maxQuestCon = min(maxSignalCon,-minSignalCon);
