% MakeSignalsCT
% 
% Make the target waveform at unit contrast.
%
% 3/6/97  dhb  Pulled out of RunExperimentCT.
%              Simplified to only make a sine wave.
	 
% Generate the waveform
x=1:imageSize;
x=(x-mean(x));
wave=sin(2*pi*cyclesPerImage*x/imageSize);

% Generate the Gaussian
gaussianX=exp(-(x/spaceConstant).^2);
gaussianY=exp(-(x/spaceConstant).^2);

% Put them together as an image
signal1 = (gaussianX.*wave)'*gaussianY;

% Make a rect of correct size.
signalRect=ScaleRect(SetRect(0,0,imageSize,imageSize),expandSize,expandSize);

% Compute signal and noise energy.
Esignal=sum(sum(signal1.*signal1));
Enoise=(noiseRmsContrast*imageSize).^2;

% Determine how many clut entries correspond to entire
% contrast range.
entriesPerContrast = 256/((LMax-LMin)/LBackground);
