function DriftDemo
% DriftDemo shows a drifting grating.
% 
% See also GratingDemo, NoiseDemo, MovieDemo.

% 2/21/02 dgp Wrote it, based on FlickerTest.
% 4/23/02 dgp HideCursor & ShowCursor.

whichScreen=0;

% window
window=Screen(whichScreen,'OpenWindow');
white=WhiteIndex(window);
black=BlackIndex(window);
gray=(white+black)/2;
if round(gray)==white
	gray=black;
end
inc=white-gray;
Screen(window,'FillRect',gray);
Screen(window,'TextSize',24);
Screen(window,'DrawText','Computing the movie ...',10,30);

% compute each frame of the movie
frames=12; % temporal period, in frames, of the drifting grating
for i=1:frames
	phase=(i/frames)*2*pi;
	% grating
	[x,y]=meshgrid(-200:200,-200:200);
	angle=30*pi/180; % 30 deg orientation.
	f=0.05*2*pi; % cycles/pixel
	a=cos(angle)*f;
	b=sin(angle)*f;
	m=exp(-((x/90).^2)-((y/90).^2)).*sin(a*x+b*y+phase);
% 	Screen(window,'PutImage',gray+inc*m);
	w(i)=Screen(whichScreen,'OpenOffscreenWindow',0,[0 0 size(m)]);
	Screen(w(i),'PutImage',gray+inc*m);
end

% show the movie
r=Screen(w(1),'Rect');
rr=CenterRect(r,screen(window,'Rect'));
Screen('Screens');	% Make sure all Rushed functions are in memory.
Screen(window,'FillRect',gray);
i=0;				% Allocate all Rushed variables.
n=round(5*FrameRate(window)); % 5 seconds
loop={
	'for i=1:n;'
		'Screen(window,''WaitBlanking'');'
		'Screen(''CopyWindow'',w(1+mod(i,frames)),window,r,rr);'
	'end;'
	'Screen(window,''FillRect'',gray);'
};
priorityLevel=MaxPriority(window,'WaitBlanking');
hidecursor;
Rush(loop,priorityLevel);
showcursor;

Screen('CloseAll');
