function FontDemo
% FontDemo shows how to get the font you want, when you're not
% sure what's available, and only certain fonts will do. This
% is a portable solution to the problem of running on various
% computers and Operating Systems that offer various fonts.
%
% In the FontDemo program we call CHAR to convert a one-string list,
% e.g. {'Arial'}, to a string, e.g. 'Arial'. The Mac version of Screen
% in fact does this automatically, and the Win version will too, but
% that enhancement hasn't been implemented yet.

% 5/23/02 dgp Wrote it.

w=Screen(0,'OpenWindow');
fprintf('New window opened with font set to %s.\n',Screen(w,'TextFont'));
for font={'Arial','Geneva','Helvetica','sans-serif'}
	Screen(w,'TextFont',char(font)); % Win: currently needs the call to CHAR.
	match=strcmp(font,Screen(w,'TextFont'));
	if match
		break;
	end
end
if ~match
	error('Couldn''t find any of the fonts we wanted.');
end
fprintf('Successfully set font to %s.\n',Screen(w,'TextFont'));
Screen(w,'Close');
