function GammaFlipDemo
% GammaFlipDemo shows the effects of flipping the CLUT and flipping the
% gamma table. Tries 8 and 10 bit gamma tables.

% 2/16/00 dgp Wrote it, in response to query by Harriet Allen.

if strcmp(computer,'PCWIN')
    error('Win: GammaFlipDemo.m not yet supported.');
end 

G=[0:255]';
GT8=[G G G];
G=[0:4:1023]';
GT10=[G G G];
for s=Screen('Screens')
	window=Screen(s,'OpenWindow');
	screen(window,'TextSize',18);
	LUT=ClutDefault(window);
	Screen(window,'SetClut',LUT);
	Ask(window,'Normal CLUT. Click to continue.');
	Screen(window,'SetClut',flipud(LUT));
	Ask(window,'Flipped CLUT. Click to continue.');
	[old,bits,err]=Screen(window,'Gamma',GT8,8);
	if ~err.set
		Screen(window,'SetClut',LUT);
		Ask(window,'Normal 8-bit gamma. Click to continue.');
	end
	[old,bits,err]=Screen(window,'Gamma',flipud(GT8),8);
	if ~err.set
		Screen(window,'SetClut',LUT);
		Ask(window,'Flipped 8-bit gamma. Click to continue.');
	end
	[old,bits,err]=Screen(window,'Gamma',GT10,10);
	if ~err.set
		Screen(window,'SetClut',LUT);
		Ask(window,'Normal 10-bit gamma. Click to continue.');
	end
	[old,bits,err]=Screen(window,'Gamma',flipud(GT10),10);
	if ~err.set
		Screen(window,'SetClut',LUT);
		Ask(window,'Flipped 10-bit gamma. Click to continue.');
	end
	Screen(window,'Close');
end
