% GetNumberDemo
%
% Get typed response from user.
%
% BUGS
% Typing an illegal number results in curtailed text.
% Quotes aren't showing up.
% If antialiasing is on then there is a faint halo around each erased character.

% 2/24/97  	dhb  Wrote it.
% 3/15/97 	dgp  Add quotes around string
% 12/10/01  awi  -Changed quote characters around string becasue to "" for Windows compatability
%                -Added font conditional
% 4/13/02   dgp  Use Arial on all platforms, eliminating need for conditional.
% 4/232/02  dgp  Use BlackIndex and WhiteIndex for consistent color at all pixelSizes.


% Open the screen
screenNumber = 0;
[window,screenRect] = Screen(screenNumber,'OpenWindow');
white=WhiteIndex(window);
black=BlackIndex(window);
HideCursor;

% Set up some text for user interface.
Screen(window,'TextFont','Arial');
Screen(window,'TextSize',18);
replyFun='GetNumber';

% Get the number, echoed
number = GetEchoNumber(window,'Enter a number (followed by Enter or Return):',100,100,black,white);

% Report the number and wait for response
Ask(window,...
	['You entered ' num2str(number) '. Hit enter or return to proceed'],...
  black,white,replyFun);

% Get the number, not echoed
Screen(window,'DrawText','Enter a number, it won''t be echoed',100,100,black);
number = GetNumber;
Screen(window,'DrawText','Enter a number, it won''t be echoed',100,100,white);

% Report the number and wait for response
Ask(window,...
	['You entered ' num2str(number) '. Hit enter or return to proceed'],...
  black,white,replyFun);

% Get a string, echoed
string = GetEchoString(window,'Enter a string:',100,100,black,white);

% Report the reply and wait for acknowledgement
Ask(window,...
	sprintf('You entered "%s". Hit enter or return to proceed',string),...
  black,white,replyFun);
	
%  Get a string, not echoed
Screen(window,'DrawText','Enter a string, it won''t be echoed',100,100,black);
string = GetString;
Screen(window,'DrawText','Enter a string, it won''t be echoed',100,100,white);

% Report the reply and wait for acknowledgement
Ask(window,...
	sprintf('You entered "%s". Hit enter or return to proceed',string),...
  black,white,replyFun);
	
% Close the screen
ShowCursor;
Screen(window,'Close');
