function DrawAxis(windowPntr, rectPlace, axisState, axisNumber)

% draw and label a joystick axis gauge.  Called by JoystickDemo.m
%
%
%

% 08/19/01      awi wrote it.


black = BlackIndex(windowPntr);
white = WhiteIndex(windowPntr);
gray = round(max([black white])/2);
screen(windowPntr,'FillRect', WhiteIndex(0),rectPlace);
squareSide=min([RectHeight(rectPlace) RectWidth(rectPlace)]);
halfSide = round(squareSide*0.5);
subSquare = CenterRect([0,0,halfSide,halfSide],rectPlace);  % us this for text positioning
textString = ['Axis ' int2str(axisNumber)];
textWidth = Screen(windowPntr,'TextWidth',textString);
textOffsetX = round((RectWidth(rectPlace) - textWidth)/2);
Screen(windowPntr,'DrawText',textString,textOffsetX,subSquare(RectTop),black);
lineY = round(RectHeight(rectPlace) / 2) + rectPlace(RectTop);
lineStartX = rectPlace(RectLeft) + (1/8) * RectWidth(rectPlace);
lineEndX = rectPlace(RectRight) - (1/8) * RectWidth(rectPlace);
halfTickHeight = round(RectHeight(rectPlace) * (1/10));
quarterTickHeight = round(RectHeight(rectPlace) * (1/20));
eigthTickHeight = round(RectHeight(rectPlace) * (1/40));
crossRect = [0 0 5 quarterTickHeight];
[cX, cY] = RectCenter(rectPlace);
axisNorm =  axisState/-axisMin * ((lineEndX - lineStartX)/2) + cX;
Screen(windowPntr,'DrawLine', gray, lineStartX, lineY, lineEndX, lineY, 4,4); %draw horizontal line
Screen(windowPntr,'DrawLine', gray, lineStartX, lineY-eigthTickHeight, lineStartX, lineY+eigthTickHeight, 4, 4); %draw left tick
Screen(windowPntr,'DrawLine', gray, lineEndX, lineY-eigthTickHeight, lineEndX, lineY+eigthTickHeight, 4, 4); %draw right tick
Screen(windowPntr,'DrawLine', gray, cX, lineY-quarterTickHeight, cX, lineY+quarterTickHeight, 4, 4); %draw center tick
Screen(windowPntr,'DrawLine',black,axisNorm, lineY-halfTickHeight, axisNorm, lineY+halfTickHeight,2,2);  %draw the gauge bar


