function DrawButton(windowPntr, rectPlace, buttonState, buttonNumber)

% draw and label a joystick button gauge.  Called by JoystickDemo.m
%
%
%

% 08/19/01      awi wrote it.

squareSide=min([RectHeight(rectPlace) RectWidth(rectPlace)]);
butRect = CenterRect([0 0 round(squareSide*0.75) round(squareSide*0.75)], rectPlace);
textY = round((rectPlace(RectBottom) - rectPlace(RectTop))/2) + rectPlace(RectTop);
textX = rectPlace(RectLeft);
tSize = 8;
Screen(windowPntr,'TextSize',tSize);
tString = [' Button ' int2str(buttonNumber)];
Screen(windowPntr,'DrawText', tString,textX, textY, BlackIndex(windowPntr));
tWidth = Screen(windowPntr,'TextWidth',[tString ' ']);
xHeight = Screen(windowPntr,'TextWidth','X');
Screen(windowPntr,'DrawLine',BlackIndex(windowPntr), textX+tWidth, textY-round(xHeight/2),butRect(RectLeft) ,textY-round(xHeight/2),1,1);

if buttonState
    screen(windowPntr,'FillOval',BlackIndex(windowPntr),butRect);
else
    screen(windowPntr,'FillOval',WhiteIndex(windowPntr),butRect);
    screen(windowPntr,'FrameOval',BlackIndex(windowPntr),butRect);
end
    
%screen(windowPntr,'FrameRect', BlackIndex(0),rectPlace);






