function DrawHat(windowPntr, rectPlace, hatState, hatNumber)

%screen(windowPntr,'FrameRect', BlackIndex(0),rectPlace);
black = BlackIndex(windowPntr);
white = WhiteIndex(windowPntr);
gray = round(max([black white])/2);

textRectSide = round(min(RectWidth(rectPlace), rectHeight(rectPlace)) * 0.75);
globRectSide = round(min(RectWidth(rectPlace), rectHeight(rectPlace)) * 0.125);
globArmSide =  round(min(RectWidth(rectPlace), rectHeight(rectPlace)) * 0.5);
globArmSideHalf = round(min(RectWidth(rectPlace), rectHeight(rectPlace)) * 0.250);
textRect = CenterRect([0 0 textRectSide textRectSide], rectPlace);
textY = textRect(RectTop);
textString = ['Hat ' int2str(hatNumber)];
textStringLength = Screen(windowPntr,'TextWidth',textString);
textX = round((RectWidth(rectPlace)- textStringLength)/2) + rectPlace(RectLeft);
screen(windowPntr,'DrawText',textString,textX,textY,black);
globRect = [0 0 globRectSide globRectSide];
[starCenterX, starCenterY] = RectCenter(rectPlace);
coRt = round(globArmSideHalf/sqrt(2));
globCenters(1,:) = [starCenterX + globArmSideHalf, starCenterY];
globCenters(2,:) = [starCenterX + coRt, starCenterY - coRt];
globCenters(3,:) = [starCenterX, starCenterY - globArmSideHalf];
globCenters(4,:) = [starCenterX - coRt, starCenterY - coRt];
globCenters(5,:) = [starCenterX - globArmSideHalf, starCenterY];
globCenters(6,:) = [starCenterX - coRt, starCenterY + coRt];
globCenters(7,:) = [starCenterX, starCenterY + globArmSideHalf];
globCenters(8,:) = [starCenterX + coRt, starCenterY + coRt];
globCenters(9,:) = [starCenterX , starCenterY];
globButtonTable(1) = HatRight;
globButtonTable(2) = HatRightUp;
globButtonTable(3) = HatUp;
globButtonTable(4) = HatLeftUp;
globButtonTable(5) = HatLeft;
globButtonTable(6) = HatLeftDown;
globButtonTable(7) = HatDown;
globButtonTable(8) = HatRightDown;
globButtonTable(9) = HatCentered;

for i = 1:9
    if globButtonTable(i) == hatState;
        Screen(windowPntr, 'FillOval', black, CenterRectOnPoint(globRect, globCenters(i,1), globCenters(i,2)));
    else
        Screen(windowPntr, 'FillOval', white, CenterRectOnPoint(globRect, globCenters(i,1), globCenters(i,2)));
        Screen(windowPntr, 'FrameOval', black, CenterRectOnPoint(globRect, globCenters(i,1), globCenters(i,2)));
    end
end













