function LineDemo
% LineDemo shows how to draw anti-aliased lines (no jaggies).
% Based on suggestions by Allen Ingling and David Brainard.
% We draw an oversized image offscreen, "scalar" times bigger than we want.
% Then we copy it to the screen, shrinking down to desired size.
% QuickDraw's CopyBits does antialiasing as it shrinks.
% To help visualize the result, we also present a 16X magnified view.
% 
% Denis Pelli, September 27, 2001

% 09/27/01  dgp Wrote it. Polished the help text.
% 04/03/02  awi Added font conditional for Mac/Windows       
% 04/13/02  dgp Use Arial font, eliminating need for conditionals.      

% window
whichScreen=0;
[window,windowRect]=Screen(whichScreen,'OpenWindow',[],[]);
white=WhiteIndex(window);
black=BlackIndex(window);
scalar=8; % The scale factor will determine how much smoothing occurs.
rect=[0 0 128 128];
r=scalar*rect;
leftRect=CenterRect(rect,windowRect);
leftRect=AlignRect(leftRect,windowRect,RectLeft);
rightRect=AdjoinRect(leftRect,leftRect,RectRight);

% draw line in big offscreen window and then copy (shrinking) to onscreen window
w=Screen(window,'OpenOffscreenWindow',white,r);
Screen(w,'DrawLine',black,r(1),r(2),r(3),r(4),scalar*1,scalar*1);
Screen('CopyWindow',w,window,r,leftRect);
Screen(w,'Close');
r=leftRect/16;
r=CenterRect(r,leftRect);
Screen('CopyWindow',window,window,r,rightRect);

% pause
Screen(window,'TextFont','Arial');
Screen(window,'TextSize',18);
Screen(window,'DrawText','The line.',leftRect(1),leftRect(2)-9);
Screen(window,'DrawText','Magnified 16X.',rightRect(1),rightRect(2)-9);
Screen(window,'DrawText',sprintf('Offscreen scalar is %d.',scalar),leftRect(1),leftRect(4)+20);

Ask(window,'Done. Hit return to quit.',black,white,'GetString');
Screen(window,'Close');
