% MouseTraceDemo
%
% Draw a curve with the mouse. 
%
% Mouse positions are saved in array thePoints;

% 8/12/97  dhb, wtf  Wrote it.
% 8/13/97  dhb			 Small modifications.
% 8/15/97  dgp			 Drag mouse instead of clicking before and after.
% 8/07/01  awi       Added font conditional, changed "button" to "buttons"
%                    and indexed the mouse button result for Windows.
% 4/11/01  awi		   Cosmetic editing of comments.
% 4/13/02  dgp       Use Arial, no need for conditional.

% Open up a window on the screen and clear it.
whichScreen = 0;
pixelSize = 8;
[theWindow,theRect] = Screen(whichScreen,'OpenWindow',0,[],pixelSize);
%Screen(theWindow,'SetClut',(0:255)'*ones(1,3));

% Move the cursor to the center of the screen
theX = theRect(RectRight)/2;
theY = theRect(RectBottom)/2;
SetMouse(theX,theY);
ShowCursor(0);

% Wait for a click and hide the cursor
Screen(theWindow,'TextFont','Arial');
Screen(theWindow,'TextSize',18);
Screen(theWindow,'DrawText','Drag mouse (i.e. hold button down) to draw',50,50,255);
while (1)
	[x,y,buttons] = GetMouse;
	if buttons(1)
	  break;
	end
end
Screen(theWindow,'DrawText','Drag mouse (i.e. hold button down) to draw',50,50,0);
%Screen(theWindow,'DrawText','Release button to finish',50,50,255);

% Loop and track the mouse, drawing the contour
[theX,theY] = GetMouse;
thePoints = [theX theY];
Screen(theWindow,'DrawLine',255,theX,theY,theX,theY);
sampleTime = 0.01;
startTime = GetSecs;
nextTime = startTime+sampleTime;
while (1)
	[x,y,buttons] = GetMouse;	
	if ~buttons(1)
		break;
	end
	if (x ~= theX | y ~= theY)
		Screen(theWindow,'DrawLine',255,theX,theY,x,y);
		theX = x; theY = y;
	end
	if (GetSecs > nextTime)
		thePoints = [thePoints ; x y];
		nextTime = nextTime+sampleTime;
	end
end
		
% Close up
Screen(theWindow,'DrawText','Click mouse to finish',50,50,255);
ShowCursor;
Screen(theWindow,'Close');

% Plot the contour in a Matlab figure
plot(thePoints(:,1),theRect(RectBottom)-thePoints(:,2));
drawnow;
figure(gcf);
