% MovieDemo2
%
% Demonstrates how to show a movie at the frame rate of the monitor. This
% is a more elaborate example than MovieDemo. 
% See also MovieDemo, ScreenTest.

% 1/21/98  dhb  This started as a program written by Geoff Loftus.
% 1/22/98  dhb  Cleaned it up for didactic purposes.
% 1/22/98  dgp	Call COMPUTER and MAXPRIORITYGETSECS to enhance compatibility.
% 2/1/98	 dgp	MaxPriority. Renamed "priority" to "priorityLevel" to avoid
%								conflict with Priority function.
% 3/12/98	dgp   Use Ask.
% 3/25/98	dgp   Delete illegal x argument in call to Ask.
% 7/17/98	dgp   Using enhanced Rush, use easy-to-read cell array for string.
% 7/21/98	dgp   Make sure all Rushed functions are in memory.
% 4/13/02 dgp   Eliminate 'PeekBlanking', which isn't used, from call to MaxPriority.
% 7/31/02 dgp   Commented out the wait for click.

% Parameters
whichScreen=0;
nRows=320;
nCols=240;
[c,maxElements]=computer;	% for compatibility with Student Matlab
if nRows*nCols>maxElements
	nCols=floor(sqrt(maxElements)/4)*4;
	nRows=floor(maxElements/nCols);
end
nFrames=round(0.5*FrameRate(whichScreen));
priorityLevel=MaxPriority(whichScreen,'GetSecs','WaitBlanking');

% Make images and cluts
offClut=zeros(256,3);
onClut=(0:255)'*[1 1 1];
image1=255*((MakeCosImage(2,0,nRows,nCols)+1)/2);
image2=255*((MakeCosImage(0,2,nRows,nCols)+1)/2);

% Open screen.  Do this before opening the
% offscreen windows so you can align offscreen
% window memory to onscreen for faster copying.
[window,windowRect]=Screen(whichScreen,'OpenWindow',0,[],8);
Screen(window,'SetClut',onClut);
imageRect=SetRect(0,0,nCols,nRows);
destRect=CenterRect(imageRect,windowRect);

% Put images into offscreen memory.  When we open an offscreen
% window we specify which on-screen window it should be
% aligned with, for fast copying.
ow1=Screen(window,'OpenOffscreenWindow',0,imageRect,8);
Screen(ow1,'PutImage',image1,imageRect);
ow2=Screen(window,'OpenOffscreenWindow',0,imageRect,8);
Screen(ow2,'PutImage',image2,imageRect);

% Set up string for Rush.  You can make this as long as you like.
% The initial call to WaitBlanking synchronizes the program with the display blanking.
missed1=zeros(nFrames,1);
missed2=zeros(nFrames,1);
GetSecs; % Preload all functions.
loop={
	'Screen(window,''WaitBlanking'');'
	'startTime=GetSecs;'
	'for i=1:nFrames;'
		'Screen(''CopyWindow'', ow1, window,imageRect,destRect);'
		'missed1(i)=Screen(window,''WaitBlanking'');'
		'Screen(''CopyWindow'', ow2, window,imageRect,destRect);'
		'missed2(i)=Screen(window,''WaitBlanking'');'
	'end;'
	'finishTime=GetSecs;'
};

% Wait for click
% Screen(window,'TextFont','Arial');
% Screen(window,'TextSize',18);
% ShowCursor(0);	% arrow cursor
% Ask(window,'Click mouse to show movie',255,0);

% Show the movie. The Rushed code does the timing.
HideCursor;
Screen('Screens');GetSecs; % Make sure all Rushed functions are in memory.
Rush(loop,priorityLevel);
ShowCursor;

% Close up
Screen('CloseAll');

% Print results
fprintf('MovieDemo2\n');
s=sprintf('Movie is %gx%g %.0f Hz.',nRows,nCols,FrameRate(whichScreen));
s=sprintf('%s Copied %.0f images/sec.',s,2*nFrames/(finishTime-startTime));
s=sprintf('%s Missed %g frames.',s,sum(sum([missed1 missed2])));
fprintf('%s\n',WrapString(s));

RestoreScreen(whichScreen); % As of 7/31/02, FrameRate may leave CLUT in strange state.
