% OffscreenDemo
%
% This is a quick demo of the off-screen windows and CopyWindow.
% All drawing (except the final instruction) is done to the offscreen 
% windows, which is then copied, by CopyWindow to the screen.
%
% See also MovieDemo.

% 08/6/96   dgp     Wrote it.
% 08/8/96   dhb     Cosmetic editing.
% 08/9/96   dhb     Force it to use main screen.
% 02/4/97   dhb     OpenWindow/OpenOffscreenWindow.
% 02/23/97  dhb     Final 2.0 interface.
% 04/15/97  dgp     Explicit screen numbers.
% 12/11/01  awi     -Re-ordered windows closing at the end becasue Windows 
%										 version seg faults if we close the onscreen window before
%                    closing the offscreen window.
%                   -Added Windows conditionals to use GetChar instead of 
%										 GetClicks for Windows version.  GetClicks is not working on 
%                    Windows yet
%                   -Added Windows conditionals for font names.
% 04/03/02   awi    -Reverted to mouse clicks for Windows and used CloseAll 
%										 for both versions after bug fixes to the 
%                    Windows versions of GetClicks and Screen 'Close'.  
% 4/13/02   dgp      Cosmetic editing. Use 'Close' because 
%                    it's best to get used to keeping track.

% Open up the onscreen window and clear it.
% If we open the screen first and force 8 bits,
% then the OpenOffscreen will be set to the same
% bitdepth.
whichScreen = 0;
[w,screenRect] = Screen(whichScreen,'OpenWindow',0,[],8);
Screen(w,'SetClut',(0:255)'*ones(1,3));
Screen(w,'FillRect',0);
HideCursor;

% Open up the offscreen world and draw into it.
[o,oRect] = Screen(whichScreen,'OpenOffscreenWindow');
Screen(o,'FillRect',0);
Screen(o,'FillRect',255,SetRect(0,0,100,100));
Screen(o,'FrameOval',128,oRect,10);
Screen(o,'TextFont','Arial');
Screen(o,'TextSize',128);
Screen(o,'DrawText','Hello',100,200,255);

% Get the image into a Matlab matrix
m = Screen(o,'GetImage',SetRect(0,0,30,30));

% Copy from the offscreen window to the onscreen window
Screen('CopyWindow',o,w);

% Make a smaller offscreen window
r=AlignRect(0.25*screenRect,screenRect,RectRight,RectBottom);
[oo,ooRect] = Screen(whichScreen,'OpenOffscreenWindow',[],r);

% Copy from offscreen to offscreen to shrink the image.
Screen('CopyWindow',o,oo);

% Blit the small image into successive onscreen locations.
% This produces a moving copy of the large image and leaves
% a trail behind it.
for i=1:100
	Screen('CopyWindow',oo,w,ooRect,r);
	r=OffsetRect(r,-2,-2);
end
Screen(w,'TextSize',24);
Screen(w,'DrawText','Click mouse to exit',10,screenRect(RectBottom)-10,255);

% Wait for a mouse click and close all of the windows
GetClicks;
ShowCursor;
Screen(o,'Close')
Screen(oo,'Close')
Screen(w,'Close')
