function [image1P,image2P] = ComputeImagePPD(p,image1Amp,image2Amp,...
																						 image1Phase,image2Phase)
% [image1P,image2P] = ComputeImagePPD(p,image1Amp,image2Amp,...
%																				image1Phase,image2Phase)
%
% Compute mixtures of the two images according to parameter p.
%
% The amplitude spectrum of the output image is defined as the
% mean amplitude spectrum of the two images.
%
% The phase spectrum of each output image is a mixture of
% each the corresponding input phase and a random phase
% spectrum.
%
% As parameter p -> zero, the phase becomes
% completely random and the two images are indistinguishable
% As p increases, we get progressively more phase information. 
%
% There are other sensible ways of doing a mixture, one
% of which is hinted at by the commented out code below.
%
% 6/29/96  dhb, gmp, if  Wrote it.
% 3/5/97   dhb           More comments, append PD to name.

[n,m] = size(image1Amp);
meanAmp = (image1Amp+image2Amp)/2;
%image1PAmp = p*image1Amp+(1-p)*meanAmp;
image1PPhase = image1Phase+(1-p)*RandPhasePD(n);
%image1P = real(ifft2(image1PAmp.*exp(sqrt(-1)*image1PPhase)));
image1P = real(ifft2(meanAmp.*exp(sqrt(-1)*image1PPhase)));
%image2PAmp = p*image2Amp+(1-p)*meanAmp;
image2PPhase = image2Phase+(1-p)*RandPhasePD(n);
%image2P = real(ifft2(image2PAmp.*exp(sqrt(-1)*image2PPhase)));
image2P = real(ifft2(meanAmp.*exp(sqrt(-1)*image2PPhase)));


