function ShowtimeDemo
% ShowtimeDemo demonstrates the use of Showtime.mex to create and display
% a QuickTime movie.
% 
% The code in the first section below, to compute a grating, and display
% it in a window using Screen 'PutImage', works perfectly at all
% pixelSizes. At present, the Showtime.mex conversion of the same Matlab
% array to a QuickTime movie seems to work correctly only if "bits" (ie
% specified pixelSize for the movie) is 8. (16 and 32 might be ok too.) I
% expect to fix that soon. However, once you've saved the QuickTime movie,
% you can display it at any depth, i.e. you can set your screen's
% pixelSize to anything you want and QuickTime will do an excellent job of
% rendering the movie appropriately.

% dgp 11/7/99 Wrote it, based on Beau Watson's Mathematica qtWrite tutorial.
% dgp 11/9/99 Put movie in root directory.
% dgp 11/13/99 Put movie on desktop. Restrict to 8, 16, or 32 bit pixelSize.
% dgp 11/15/99 Add Showtime 'OpenWindow' and 'CloseWindow'.
% awi 4/3/02   Added Windows conditional.
% dgp 9/10/02 Updated line 61 call to CD to use new DesktopFolder function.

if strcmp(computer, 'PCWIN')
    error('Win: the Showtime extension is not yet provided'); 
end

clear Showtime;

% window
whichScreen=0;
window=Showtime('OpenWindow',whichScreen);
%window=Screen(whichScreen,'OpenWindow');
white=GrayIndex(window,1);
black=GrayIndex(window,0);
gray=GrayIndex(window,0.5);
if round(gray)==white
	gray=black;
end
inc=white-gray;
Screen(window,'FillRect',gray);

% grating
frames=90;
[x,y]=meshgrid(-50:50,-50:50);
angle=17*pi/180; % arbitrary 17 deg orientation
f=0.03*2*pi;
a=cos(angle)*f;
b=sin(angle)*f;
rate=FrameRate(window);
hz=2;
grating=uint8(zeros(size(x))); % uint8 takes up 1/8 the space as double
grating(:,:,frames)=grating;
for i=1:frames
 	m=exp(-((x/25).^2)-((y/25).^2)).*sin(a*x+b*y+2*pi*(i/rate)*hz);
	t=8*(i-(frames+1)/2)/frames;
	grating(:,:,i)=gray+inc*m*exp(-t^2);
	Screen(window,'PutImage',grating(:,:,i));
end

% Save the QuickTime movie file in the user's desktop.
cd(DesktopFolder);
filename='DriftingGrating.mov';

% Make the movie, and save it to disk as a QuickTime movie file.
rows=size(grating,1);
cols=size(grating,2);
trackTimescale=600;
frameDuration=round(trackTimescale/FrameRate(whichScreen)); 
preload=1;
movie=Showtime('MovieCreate',filename,window);
Showtime('VideoTrackCreate',movie,rows,cols,trackTimescale,preload);
Showtime('VideoMediaCreate',movie);
bits=Screen(window,'PixelSize');
if bits<8;
	bits=8;
end
Showtime('VideoMediaSamplesAdd',movie,grating,bits,frameDuration);
Showtime('VideoMediaSave',movie);
Showtime('VideoTrackSamplesSet',movie);
Showtime('VideoTrackSave',movie);
%Showtime('MovieUserDataAdd',movie,'A movie demo.','inf');
Showtime('MovieSave',movie);
fprintf('Your new %d-bit QuickTime movie "%s" is on your desktop.\n',bits,filename);
Showtime('CloseWindow',window);
% Screen(window,'Close');

% show the movie
movie=Showtime('GetFromFile',filename);
desc=Showtime('GetImageDescription',movie); % get various useful facts about our movie
list=Showtime('GetCodecNameList');
Showtime('LoadIntoRam',movie);
window=Showtime('OpenWindow',whichScreen);
Showtime('Window',movie,window);
%Screen(window,'FillRect',gray);
%Showtime('Scale',movie,2);
Showtime('Show',movie);
% for i=1:frames
% 	Showtime('MovieFrameDisplay',movie,i)
% end
Showtime('Dispose',movie);
Showtime('CloseWindow',window);
