function ChangeStringsHere(theDir,oldString,newString)
% ChangeStringsHere([theDir],oldString,newString)
%
% Driver script to change all instances of a string in .m files
% in a directory.  It makes a copy of the original of any changed
% files and saves it with '.old' appended to the end.
%
% If argument theDir is omitted, the folder is taken to be the
% current working directory (see pwd).
%
% WARNING:  This function has been tested only modestly and sometimes it
% fails because of file open/create problems.  I haven't been able
% to track down exactly why or where the failure occurs.  Personally,
% I have been using FindStringsHere to locate things I might want to
% change and then changing them by hand.  In any case, I recommend
% making a copy of your folder before using this function.
%
% 5/15/96  dhb  Wrote it.
% 5/15/96  dgp  Cosmetic changes.
% 6/24/96  dhb  Wrote as function, added query.

if (nargin == 2)
	oldString = theDir;
	newString = oldString;
	theDir = pwd;
end

disp(sprintf('Looking for string: %s',oldString));
disp(sprintf('Replacing with string: %s',newString));
disp(sprintf('Looking in folder: %s',theDir));
disp('The action of this routine is not reversible.');
disp('The routine sometimes screws up because of some unknown bug.');
disp('You should back up your files before running it');
doIt = input('Enter yes if you want to proceed: ','s');
if (~isempty(doIt))
	if (doIt(1) == 'y' | doIt(1) == 'Y')
		theFiles = GetFilenames(pwd,'.m');
		for i = 1:size(theFiles,1)
			if (~strcmp('ChangeStringsHere.m',deblank(theFiles(i,:))) & ...
				  ~strcmp('FindStringsHere.m',deblank(theFiles(i,:))))
				SearchAndReplace(theFiles(i,:),theFiles(i,:),oldString,newString);
			end
		end
	end
end
