function CopyFile(oldFilename,newFilename)
% CopyFile(oldFilename,newFilename)
%
% Make a copy of a file.
%
% 5/15/96  dhb  Wrote it.
% 5/15/95  dgp  Cosmetic changes: use deblank, corrected error messages.

% Check args, provide usage.
if nargin~=2 | ~isstr(oldFilename) | ~isstr(newFilename)
	error('Usage: CopyFile(oldFilename,newFilename)');
end

% Strip whitespace and decide whether we are working in place.
newFilename = deblank(newFilename);
oldFilename = deblank(oldFilename);
if strcmp(newFilename,oldFilename)
	error('CopyFile: Cannot copy file onto itself');
end
newFile=fopen(newFilename,'wt');
oldFile=fopen(oldFilename,'rt');
if newFile == (-1)
	fclose(oldFile);
	error(['CopyFile: Couldn''t create file ' newFilename]);
end
if oldFile == (-1)
	error(['CopyFile: Couldn''t open file ' oldFilename]);
end

line=fgets(oldFile);
while(line ~= [ -1 ]) % read till eof
	fprintf(newFile,'%s',line);
	line=fgets(oldFile);
end
fclose(newFile);
fclose(oldFile);
