function FindStringsHere(theDir,theString)
% FindStringsHere([theDir],theString)
%
% Driver script to find all instances of a string in .m files
% in a directory.
%
% If argument theDir is omitted, the folder is taken to be the
% current working directory (see pwd).
%
% 5/15/96  dhb  Wrote it.
% 5/15/96  dgp  Cosmetic changes.
% 6/24/96  dhb  Wrote as function.

if (nargin == 1)
	theString = theDir;
	theDir = pwd;
end

disp(sprintf('Looking for string: %s',theString));
disp(sprintf('Looking in folder: %s',theDir));

theFiles = GetFilenames(theDir,'.m');
for i = 1:size(theFiles,1);
	if (~strcmp('ChangeStringsHere.m',deblank(theFiles(i,:))) & ...
		  ~strcmp('FindStringsHere.m',deblank(theFiles(i,:))))
		FindStringInFile(theFiles(i,:),theString);
	end
end
