function n = SearchAndReplace(oldFilename,newFilename,oldString,newString)
% n = SearchAndReplace(oldFilename,newFilename,oldString,newString)
%
%	Reads text file oldFilename, replaces all instances of oldString by
%	newString, and saves the modified file as newFilename.
%
% WARNING:  This function has been tested only modestly and sometimes it
% fails because of file open/create problems.  I haven't been able
% to track down exactly why or where the failure occurs.  Personally,
% I have been using FindStringsHere to locate things I might want to
% change and then changing them by hand.  In any case, I recommend
% making a copy of your folder before using this function.
%
% 5/14/97  dgp  Wrote it.
% 5/15/96  dhb  Strip whitespace from filenames.
%          dhb  Don't create new file if no changes were made.
%          dhb  Special case for identical old and new filenames.
%          dhb  Open files as text, as per documentation.
% 5/15/96  dgp  Cosmetic changes: use deblank, fprintf.
% 5/15/96  dgp  Final del command now supports filenames with quotes and spaces.

% Check args, provide usage.
if nargin~=4 | ~isstr(oldFilename) | ~isstr(newFilename)
	error('Usage: n=SearchAndReplace(oldFilename,newFilename,oldString,newString);');
end

% Strip trailing whitespace and decide whether we are working in place.
newFilename = deblank(newFilename);
oldFilename = deblank(oldFilename);
if (strcmp(newFilename,oldFilename) == 1)
	INPLACE = 1;
	CopyFile(oldFilename,[oldFilename,'.old']);
	oldFilename = [oldFilename,'.old'];
	newFile=fopen(newFilename,'r+t');
	oldFile=fopen(oldFilename,'rt');
	[ftype,fcrea] = filetype(oldFilename);
	filetype(newFilename,ftype,fcrea);
else
	INPLACE = 0;
	newFile=fopen(newFilename,'wt');
	oldFile=fopen(oldFilename,'rt');
end
if newFile == (-1)
	fclose(oldFile);
	error(['SearchAndReplace: Couldn''t create file ' newFilename]);
end
if oldFile == (-1)
	error(['SearchAndReplace: Couldn''t open file ' oldFilename]);
end

if INPLACE
	fprintf('%s\n',newFilename);
else
	fprintf('%s\n',oldFilename);
end

n=0;
oldLine=fgets(oldFile);
while(oldLine ~= [ -1 ]) % read till eof
	newLine=[];
	oldPtr=1;
	if(length(oldLine)>=length(oldString))
		matches=findstr(oldLine,oldString);
	else
		matches=[];
	end
	n=n+length(matches);
	for match=[matches length(oldLine)+1];
		newLine=[newLine oldLine(oldPtr:match-1)];
		oldPtr=match;
		if(match>length(oldLine))
			break;
		end
		newLine=[newLine newString];
		oldPtr=oldPtr+length(oldString);
	end
	fprintf(newFile,'%s',newLine);
	oldLine=fgets(oldFile);
end
fclose(newFile);
if ~strcmp(newFilename,oldFilename)
	fclose(oldFile);
end

% Trash new file if no changes were made
if n==0
	if INPLACE
		filename=oldFilename;
	else
		filename=newFilename;
	end
	% double any quote characters
	for i=fliplr(findstr(filename,''''))
		filename=filename([1:i i:length(filename)]);
	end
	% use quotes to allow filenames that include spaces
	eval(['delete ''',filename,'''']);
else
	fprintf('	Changed %g instances of %s to %s\n',n,oldString,newString);
end
