function [fit_out,x,err] = FitGammaPow(values_in,measurements,values_out,x0)
% [fit_out,x,err] = FitGammaPow(values_in,measurements,values_out,x0)
%
% Fit extended power function to gamma data.
%

% 4/08/02 awi  turned off warnings before calling constr to avoid future obsolete warning.  
% 4/13/02 dgp Fixed the warning suppression to save and restore original state.

% Standard minimization sequence
options = foptions;
options(1) = 0;
options(14) = 600;
old=warning;
warning off
x = constr('FitGammaExtPFun',x0,options,[],[],[],values_in,measurements);
warning(old)

% Now compute fit values and error to data for return
fit_out = ComputeGammaExtP(x,values_out);
err = FitGammaExtPFun(x,values_in,measurements);
