function [fit_out,x,err] = FitGammaPow(values_in,measurements,values_out,x0)
% [fit_out,x,err] = FitGammaPow(values_in,measurements,values_out,x0)
%
% Fit power function to gamma data.
%
% NOTE: Uses CONSTR, which is part of the Mathworks Optimization Toolbox.
% 
% Also see FitGamma, FitGammaDemo.

% 4/08/02 awi  turned off warnings while calling constr to avoid future obsolete warning

% Standard minimization sequence
options = foptions;
options(1) = 0;
options(14) = 600;
warning off
x = constr('FitGammaPowFun',x0,options,[],[],[],values_in,measurements);
warning on

% Now compute fit values and error to data for return
fit_out = ComputeGammaPow(x,values_out);
err = FitGammaPowFun(x,values_in,measurements);
