function [calNumber,romVersion,intTime,serialNo,rawResponse] = CRSColorGetInfo
% [calNumber,romVersion,intTime,serialNo,rawResponse] = CRSColorGetInfo
% 2/23/03  eh  Began it
% 2/25/03  jb  Finished it.
% 2/26/03  eh  Checked it.

% Report information from the CRS meter, obtained with the IDR command.
global crsColorInfo

% Write a command and get response
cmd = '                                ';
cmd(1:3) = 'IDR';
cmd(4) = char(10);
PSYCHSERIAL('Write',crsColorInfo,cmd);

% Read Response
rawResponse = PSYCHSERIAL('ReadRaw',crsColorInfo,32);
if strncmp(rawResponse,'ER',2)
	error('IDR returned an error from the CRS color meter');
end

if strncmp(rawResponse,'OK',2)
	calNumber = str2num(rawResponse(6));
	romVersion = str2num(rawResponse(8:10));
	intTime = str2num(rawResponse(12:17));
	serialNo = str2num(rawResponse(19:26));
	% fprintf('IDR full response: %s\n', rawResponse);
	% fprintf('IDR returned calibration number: %g\n', calNumber);
	% fprintf('IDR returned ROM version: %g\n', romVersion);
	% fprintf('IDR returned integration time: %g\n', intTime);
	% fprintf('IDR returned serial number: %d\n', serialNo);
	% fprintf('\n');
end
