function crsColorInfo = CRSColorInit(portNameIn,portNameOut)
% crsColorInfo = CRSColorInit([portNameIn,portNameOut])
%
% Initialize the CRS colorimeter port.
%
% 2/2/03   dhb  Wrote it.

global crsColorInfo

% Get default port names if not passed.
if (nargin < 2 | isempty(portNameIn))
	ports = LoadCalFile('CRSCOLORPORTS');
	if (isempty(ports))
		portNameIn = '.U93In';
		portNameOut = '.U93Out';
	else
		portNameIn = ports.in;
		portNameOut = ports.out;
	end
end

% Only open if we haven't already.
if (isempty(crsColorInfo))
  crsColorInfo = PSYCHSERIAL('OpenRaw',portNameIn,portNameOut);
	CRSColorZeroCal;
end

