function CRSColorSetIntTime(intTimeMsecs)
% CRSColorSetIntTime(intTimeMsecs)
%
% Set the integration time.  Uses IDR to get current
% information, substitutes new integration time into
% the string, and writes it back using IDS command.
%
% xx/xx/03	jb			Unfinished
% 2/27/03	pw			Did something.
% 4/24/03	dhb et al.	Don't overwrite passed integration time.

global crsColorInfo

% Write a command and get response
cmd = '                                ';
cmd(1:3) = 'IDR';
cmd(4) = char(10);
PSYCHSERIAL('Write',crsColorInfo,cmd);

%read response
intResponse = PSYCHSERIAL('ReadRaw',crsColorInfo,32);
if strncmp(intResponse,'ER',2)
	error('IDR returned an error from the CRS color meter');
end

% Round intTimeMsecs to two places
%intTimeMsecs = str2num(intResponse(12:17));
%intTimeMsecs = round(100*intTimeMsecs)/100;

% Get IDR command response
[nil,nil,nil,nil,idrResponse] = CRSColorGetInfo;

if (intTimeMsecs > 343)
	error('intTimeMsecs is too long, max is 343 mSecs.');
elseif (intTimeMsecs > 99.99)
	idrResponse(12:17) = sprintf('%3.2f',intTimeMsecs);
elseif (intTimeMsecs > 9.99)
	idrResponse(12) = '0';
	idrResponse(13:17) = sprintf('%2.2f',intTimeMsecs);
elseif (intTimeMsecs > 0)
	idrResponse(12:13) = '00';
	idrResponse(14:17) = sprintf('%1.2f',intTimeMsecs);
else
	error('intTimeMsecs is less than 0.');
end


idsCommand = '                                ';
insCommand = ['IDS,' idrResponse(6:28) char(10)];
idsCommand(1:28) = [insCommand];
PSYCHSERIAL('Write',crsColorInfo,idsCommand);

% Read Response
rawResponse = PSYCHSERIAL('ReadRaw',crsColorInfo,32);
if strncmp(rawResponse,'ER',2)
	error('IDS returned an error from the CRS color meter');
end

if strncmp(rawResponse,'OK',2)
	[nil,nil,newIntTime,nil,newResponse] = CRSColorGetInfo;	
	if (intTimeMsecs ~= newIntTime)
		fprintf('Desired and returned integration times don''t match\n');
		fprintf('Desired integration time: %g, new integration time = %g\n',intTimeMsecs,newIntTime);
		error;
	else
		fprintf('Integration times match:\n');
		fprintf('Desired integration time: %g, new integration time: %g\n',intTimeMsecs,newIntTime);
	end
end
